/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cpcnpay.core.strategy.notice.internal;

import com.biz.crm.cpcnpay.core.common.enums.CpcnNoticeType;
import com.biz.crm.cpcnpay.core.notice.Notice4618Request;
import com.biz.crm.cpcnpay.core.notice.NoticeRequest;
import com.biz.crm.cpcnpay.core.service.notifier.Notice4618Listener;
import com.biz.crm.cpcnpay.core.strategy.notice.NoticeStrategy;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class Notice4618Strategy
implements NoticeStrategy<Notice4618Request> {
    private static final Logger log = LoggerFactory.getLogger(Notice4618Strategy.class);
    @Autowired(required=false)
    private List<Notice4618Listener> notice4618Listeners;

    @Override
    public String getCode() {
        return CpcnNoticeType.NOTICE_4618.getCode();
    }

    @Override
    public Notice4618Request exchange(NoticeRequest request) throws Exception {
        return new Notice4618Request(request.getDocument());
    }

    @Override
    public void handler(NoticeRequest request) {
        try {
            Notice4618Request notice4618Request = this.exchange(request);
            if (!CollectionUtils.isEmpty(this.notice4618Listeners)) {
                for (Notice4618Listener listener : this.notice4618Listeners) {
                    listener.onNotice(notice4618Request);
                }
            }
        }
        catch (Exception e) {
            log.error("\u5f00\u6237/\u7ed1\u5361\u7ed3\u679c\u901a\u77e5\u51fa\u73b0\u9519\u8bef", (Throwable)e);
            throw new RuntimeException(e.getLocalizedMessage());
        }
    }
}

