package com.biz.crm.cpcnpay.common.security;

import java.security.NoSuchAlgorithmException;

/**
 * 验证方法接口
 *
 * @author Keller
 */
public interface Verifier {

  /**
   * 验证内容的签名
   *
   * @param message
   * @param signature
   * @return
   */
  boolean verify(String message, String signature) throws Exception;

  /**
   * 验证内容的签名
   *
   * @param data
   * @param signature
   * @return
   */
  boolean verify(byte[] data, byte[] signature) throws NoSuchAlgorithmException, Exception;

  /**
   * 对称加密
   *
   * @param message
   * @param symmetricCipher
   * @return
   */
  String symmetricEncrypt(String message, String symmetricCipher) throws Exception;

  /**
   * 对称加密
   *
   * @param message
   * @return
   */
  String asymmetricEncrypt(byte[] message) throws Exception;

  /**
   * 序列号号
   *
   * @return
   */
  String getSN();
}
