package com.biz.crm.cpcnpay.core.notice;

import com.biz.crm.cpcnpay.common.utils.XmlUtils;
import lombok.Getter;
import lombok.ToString;
import org.w3c.dom.Document;

/**
 * 2736-商户进件状态变更通知
 *
 * @author Keller
 */
@Getter
@ToString
public class Notice2736Request {

  /**
   * 进件状态
   * <p>
   * 30 - 正反扫权限已获取，其他待处理
   * 40 - 全部权限已获取
   * 50 - 失败
   */
  private String status;
  /**
   * 商户号授权状态:(在接口进件支付方式为微信 时返回)
   * <p>
   * 10=未授权
   * 20=已授权
   */
  private String authStatus;
  /**
   * 响应代码
   */
  private String responseCode;
  /**
   * 响应消息
   */
  private String responseMessage;
  /**
   * 响应时间 格式:yyyyMMddhh24mmss
   */
  private String responseTime;
  /**
   * 机构编号
   */
  private String institutionID;
  /**
   * 申请流水号
   */
  private String applyNo;
  /**
   * 用户 ID
   */
  private String userID;
  /**
   * 商户号
   */
  private String merchantID;

  public Notice2736Request(Document document) throws Exception {
    this.status = XmlUtils.getNodeText(document, "Status");
    this.authStatus = XmlUtils.getNodeText(document, "AuthStatus");
    this.responseCode = XmlUtils.getNodeText(document, "ResponseCode");
    this.responseMessage = XmlUtils.getNodeText(document, "ResponseMessage");
    this.responseTime = XmlUtils.getNodeText(document, "ResponseTime");
    this.institutionID = XmlUtils.getNodeText(document, "InstitutionID");
    this.applyNo = XmlUtils.getNodeText(document, "ApplyNo");
    this.userID = XmlUtils.getNodeText(document, "UserID");
    this.merchantID = XmlUtils.getNodeText(document, "MerchantID");
  }

}
