package com.biz.crm.cpcnpay.core.notice;

import com.biz.crm.cpcnpay.common.utils.XmlUtils;
import lombok.Getter;
import lombok.ToString;
import org.w3c.dom.Document;

/**
 * 5088-冻结订单分账撤销通知
 *
 * @author Keller
 */
@Getter
@ToString
public class Notice5088Request {
  /**
   * 机构编号
   */
  private String institutionID;
  /**
   * 原支付交易流水号
   */
  private String paymentTxSN;

  /**
   * 撤销交易流水号
   */
  private String txSN;
  /**
   * 备注
   */
  private String remark;
  /**
   * 状态:
   *
   * 10=受理成功
   * 20=撤销成功
   * 30=撤销失败
   */
  private String status;
  /**
   * 撤销时间
   * Status=20 时非空，格式：yyyyMMddHHmmssSSS
   */
  private String responseTime;
  /**
   * 响应码
   */
  private String responseCode;
  /**
   * 响应消息
   */
  private String responseMessage;

  public Notice5088Request(Document document) throws Exception {
    this.institutionID = XmlUtils.getNodeText(document, "InstitutionID");
    this.paymentTxSN = XmlUtils.getNodeText(document, "PaymentTxSN");
    this.txSN = XmlUtils.getNodeText(document, "TxSN");
    this.remark = XmlUtils.getNodeText(document, "Remark");
    this.status = XmlUtils.getNodeText(document, "Status");
    this.responseTime = XmlUtils.getNodeText(document, "ResponseTime");
    this.responseCode = XmlUtils.getNodeText(document, "ResponseCode");
    this.responseMessage = XmlUtils.getNodeText(document, "ResponseMessage");
  }

}
