package com.biz.crm.cpcnpay.core.service.internal;

import com.alibaba.fastjson.JSON;
import com.biz.crm.cpcnpay.core.config.CpcnConfig;
import com.biz.crm.cpcnpay.core.notice.NoticeRequest;
import com.biz.crm.cpcnpay.core.service.NoticeService;
import com.biz.crm.cpcnpay.core.strategy.notice.NoticeManager;
import com.biz.crm.cpcnpay.core.strategy.notice.NoticeStrategy;
import com.biz.crm.cpcnpay.core.vo.NoticeInfo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

/**
 * 处理中金回调参数
 *
 * @author Keller
 */
@Slf4j
@Service
public class NoticeServiceImpl implements NoticeService {

  @Autowired
  private NoticeManager noticeManager;
  @Autowired
  private CpcnConfig cpcnConfig;

  @Override
  public void handlerNotice(NoticeInfo info) {
    try {
      log.error("中金原始信息:{}", info.getMessage());
      log.error("中金原始签名:{}", info.getSignature());
      NoticeRequest noticeRequest = new NoticeRequest(info.getMessage(), info.getSignature(), cpcnConfig);
      log.error("中金回调信息:{}", noticeRequest.getPlainText());
      NoticeStrategy service = noticeManager.getHandler(noticeRequest.getTxCode());
      Assert.notNull(service, String.format("获取中金回调处理器为空:[%s]", noticeRequest.getTxCode()));
      service.handler(noticeRequest);
      log.error("中金回调处理结束：{}", JSON.toJSONString(noticeRequest));
    } catch (Exception e) {
      log.error("处理中金回调数据出现错误", e);
      throw new IllegalArgumentException(e.getMessage());
    }
  }
}
