package com.biz.crm.cpcnpay.core.strategy.tx.internal;

import com.biz.crm.cpcnpay.core.common.enums.CpcnRequestType;
import com.biz.crm.cpcnpay.core.strategy.tx.AbstractTxStrategy;
import com.biz.crm.cpcnpay.core.tx.statement.Tx1850Request;
import com.biz.crm.cpcnpay.core.tx.statement.Tx1850Response;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * 1850-对账文件下载
 *
 * <pre>
 *    1850-对账文件下载交易接口，机构系统通过该接口可以从支付 平台服务器下载指定日期内特定批次号的对账文件。
 *    机构系统按照接 口报文结构组装请求报文提交至支付平台，支付平台返回文件压缩包。
 * </pre>
 *
 * @author Keller
 */
@Component
@Slf4j
public class Tx1850Strategy extends AbstractTxStrategy<Tx1850Request, Tx1850Response> {

  @Override
  public String getCode() {
    return CpcnRequestType.TX_1850_REQUEST.getCode();
  }

  @Override
  public Class<Tx1850Response> getResponse() {
    return Tx1850Response.class;
  }
}
