package com.biz.crm.cpcnpay.core.strategy.tx.internal;

import com.biz.crm.cpcnpay.core.common.enums.CpcnRequestType;
import com.biz.crm.cpcnpay.core.strategy.tx.AbstractTxStrategy;
import com.biz.crm.cpcnpay.core.tx.aggregate.Tx5026Request;
import com.biz.crm.cpcnpay.core.tx.aggregate.Tx5026Response;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 *  5026-退款查询
 *
 * <pre>
 *     机构系统通过该接口可以对5021-退款交易进行查询，支付平台返回该笔退款交易的退款金额、状态等信息。
 * </pre>
 *
 * @author Keller
 */
@Component
@Slf4j
public class Tx5026Strategy extends AbstractTxStrategy<Tx5026Request, Tx5026Response> {

  @Override
  public String getCode() {
    return CpcnRequestType.TX_5026_REQUEST.getCode();
  }

  @Override
  public Class<Tx5026Response> getResponse() {
    return Tx5026Response.class;
  }
}
