package com.biz.crm.cpcnpay.core.tx.aggregate;

import com.biz.crm.cpcnpay.core.tx.TxBaseRequest;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

/**
 * 5016-订单关闭
 *
 * @author Keller
 */
@Getter
@Setter
@ToString
public class Tx5014Request extends TxBaseRequest {

  private String txSN;

  private String paymentTxSN;

  private String closeType;

  @Override
  public void process() throws Exception {
    DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
    DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
    Document document = documentBuilder.newDocument();
    Element Request = document.createElement("Request");
    Element Head = document.createElement("Head");
    Element Body = document.createElement("Body");
    Element TxCode = document.createElement("TxCode");
    Element InstitutionID = document.createElement("InstitutionID");
    Element TxSN = document.createElement("TxSN");
    Element PaymentTxSN = document.createElement("PaymentTxSN");
    Element CloseType = document.createElement("CloseType");
    Request.setAttribute("version", "2.1");
    document.appendChild(Request);
    Request.appendChild(Head);
    Head.appendChild(TxCode);
    TxCode.setTextContent(this.txCode);
    Request.appendChild(Body);
    Body.appendChild(InstitutionID);
    InstitutionID.setTextContent(cpcnConfig.getInstitutionID());
    Body.appendChild(TxSN);
    TxSN.setTextContent(this.txSN);
    Body.appendChild(PaymentTxSN);
    PaymentTxSN.setTextContent(this.paymentTxSN);
    Body.appendChild(CloseType);
    CloseType.setTextContent(this.closeType);
    postProcess(document);
  }

}
