package com.biz.crm.cpcnpay.core.tx.cancleAccount;

import com.biz.crm.cpcnpay.core.tx.TxBaseRequest;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import javax.validation.constraints.NotBlank;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

/**
 * 5081-冻结订单分账撤销
 * @author Keller
 */
@Getter
@Setter
@ToString
public class Tx5088Request extends TxBaseRequest {
  /**
   * 分账撤销流水号
   */
  @NotBlank(message = "分账撤销流水号不能为空")
  private String txSN;
  /**
   * 原支付交易流水号，5011 的交易流水号
   */
  @NotBlank(message = "原支付交易流水号，5011 的交易流水号不能为空")
  private String paymentTxSN;
  /**
   * 分账撤销交易状态
   * 10=受理成功
   * 20=撤销成功
   * 30=撤销失败
   */
  private String status;

  /**
   * 备注
   */
  private String remark;


  /**
   * 撤销成功时间，Status=20 时非空，格式：
   * yyyyMMddHHmmssSSS
   */
  private String responseTime;

  /**
   * 响应代码
   */
  private String responseCode;

  /**
   * 响应消息
   */
  protected String responseMessage;

  @Override
  public void process() throws Exception {
    DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
    DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
    Document document = documentBuilder.newDocument();
    Element Request = document.createElement("Request");
    Element Head = document.createElement("Head");
    Element InstitutionID = document.createElement("InstitutionID");
    Element TxCode = document.createElement("TxCode");
    Element Body = document.createElement("Body");
    Element txSN = document.createElement("TxSN");
    Element paymentTxSN = document.createElement("PaymentTxSN");
    Element status = document.createElement("Status");
    Element remark = document.createElement("Remark");
    Element responseTime = document.createElement("ResponseTime");
    Element responseCode = document.createElement("ResponseCode");
    Element responseMessage = document.createElement("ResponseMessage");
    Request.setAttribute("version", "2.1");
    document.appendChild(Request);
    Request.appendChild(Head);
    Head.appendChild(TxCode);
    TxCode.setTextContent(this.txCode);
    Request.appendChild(Body);
    Body.appendChild(InstitutionID);
    InstitutionID.setTextContent(cpcnConfig.getInstitutionID());
    Body.appendChild(txSN);
    txSN.setTextContent(this.txSN);
    Body.appendChild(paymentTxSN);
    paymentTxSN.setTextContent(this.paymentTxSN);
    Body.appendChild(status);
    status.setTextContent(this.status);
    Body.appendChild(responseTime);
    responseTime.setTextContent(this.responseTime);
    Body.appendChild(remark);
    remark.setTextContent(this.remark);
    Body.appendChild(responseCode);
    responseCode.setTextContent(this.responseCode);
    Body.appendChild(responseMessage);
    responseMessage.setTextContent(this.responseMessage);
    postProcess(document);
  }
}
