package com.biz.crm.cpcnpay.core.tx.enrollment;

import com.biz.crm.cpcnpay.core.tx.TxBaseRequest;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import javax.validation.constraints.NotBlank;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

/**
 * 7703-壹企付用户签约入网
 *
 * @author Keller
 */
@Getter
@Setter
@ToString
public class Tx7703Request extends TxBaseRequest {
  /**
   * 申请流水号
   */
  @NotBlank(message = "申请流水号不能为空")
  private String applyNo;
  /**
   * 用户ID
   *
   * 已开户的个体工商户或企业用户ID
   */
  @NotBlank(message = "用户ID不能为空")
  private String userID;
  /**
   * 协议模板编号
   *
   * MBOSS 系统为机构/商户维护,线下告知商户
   */
  @NotBlank(message = "协议模板编号不能为空")
  private String protocolNumber;
  /**
   * 协议签署人类型
   *
   * 10-企业法人(企 业) 20-经办人(企业) 30-个体工商户自 身(个体)
   * 会根据实际 UserID 查会员后 判断类型与本字段上传是否一 致
   */
  @NotBlank(message = "协议签署人类型不能为空")
  private String protocolSignerType;

  /**
   *
   * 协议签署人手机号 ProtocolSignerType=10、30、40 时，选填
   * ProtocolSignerType=20 时，不展示
   * 协议签署人类型为：10 企业法人（企业）时可上送；或 30-个体工商户自
   * 身（个体）；或 40-个人小微商户可上送，不上送协议签署手机号时默认以首次
   * 开户手机号作为协议签署手机号。
   * 上送协议签署手机号时，
   * 协议签署人类型为“10 企业法人（企业）”时，协议签署手机号要求：法
   * 人本人在运营商开通的手机号
   * 协议签署人类型为：“30-个体工商户自身”（个体）或“40-个人小微商户”
   * 时，时可上送，不上送时默认以首次开户手机号作为协议签署手机号。协议签署
   * 手机号要求（下述 3 选 1）：1、静默绑卡成功的银行预留手机号 2、快捷绑卡成
   * 功的银行预留手机号 3、本人在运营商开通的手机号
   */
  private String protocolSignPhoneNumber;
  /**
   * 经办人手机号
   *
   * ProtocolSignerType=20时，必填
   */
  private String agentPhoneNumber;
  /**
   * 经办人姓名
   * ProtocolSignerType=20 时，必填
   */
  private String agentName;
  /**
   * 经办人身份证号
   *
   * ProtocolSignerType=20 时，必填
   */
  private String agentIDNumber;
  /**
   * 立即签约 10-是 20-否
   *
   * 10-是:给签署人下发短信验证 码，签署人在商户页面输入短 信验证码跳转到中金商户自助 入网系统进行签约
   * 20-否:签署人在中金商户自助 入网页面登录签约
   */
  private String immediatelySign;

  /**
   * 后台通知地址
   *
   * 注:商户上传以这个地址为准，商户未上传以机构配置后台通知为准
   */
  private String noticeURL;

  @Override
  public void process() throws Exception {
    DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
    DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
    Document document = documentBuilder.newDocument();
    Element Request = document.createElement("Request");
    Element Head = document.createElement("Head");
    Element InstitutionID = document.createElement("InstitutionID");
    Element TxCode = document.createElement("TxCode");
    Element Body = document.createElement("Body");
    Element ApplyNo = document.createElement("ApplyNo");
    Element UserID = document.createElement("UserID");
    Element ProtocolNumber = document.createElement("ProtocolNumber");
    Element ProtocolSignerType = document.createElement("ProtocolSignerType");
    Element ProtocolSignPhoneNumber = document.createElement("ProtocolSignPhoneNumber");
    Element AgentPhoneNumber = document.createElement("AgentPhoneNumber");
    Element AgentName = document.createElement("AgentName");
    Element AgentIDNumber = document.createElement("AgentIDNumber");
    Element ImmediatelySign = document.createElement("ImmediatelySign");
    Element NoticeURL = document.createElement("NoticeURL");

    Request.setAttribute("version", "2.1");
    document.appendChild(Request);
    Request.appendChild(Head);
    Head.appendChild(InstitutionID);
    InstitutionID.setTextContent(cpcnConfig.getInstitutionID());
    Head.appendChild(TxCode);
    TxCode.setTextContent(this.txCode);
    Request.appendChild(Body);
    Body.appendChild(ApplyNo);
    ApplyNo.setTextContent(this.applyNo);
    Body.appendChild(UserID);
    UserID.setTextContent(this.userID);
    Body.appendChild(ProtocolNumber);
    ProtocolNumber.setTextContent(this.protocolNumber);
    Body.appendChild(ProtocolSignPhoneNumber);
    ProtocolSignPhoneNumber.setTextContent(this.protocolSignPhoneNumber);
    Body.appendChild(ProtocolSignerType);
    ProtocolSignerType.setTextContent(this.protocolSignerType);
    Body.appendChild(AgentPhoneNumber);
    AgentPhoneNumber.setTextContent(this.agentPhoneNumber);
    Body.appendChild(AgentName);
    AgentName.setTextContent(this.agentName);
    Body.appendChild(AgentIDNumber);
    AgentIDNumber.setTextContent(this.agentIDNumber);
    Body.appendChild(ImmediatelySign);
    ImmediatelySign.setTextContent(this.immediatelySign);
    Body.appendChild(NoticeURL);
    NoticeURL.setTextContent(this.noticeURL);
    postProcess(document);
  }
}
