package com.biz.crm.cpcnpay.core.tx.foundationaccount;

import com.biz.crm.cpcnpay.core.tx.TxBaseRequest;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

@Getter
@Setter
@ToString
public class Tx4692Request extends TxBaseRequest {

    private String userID;

    //开始日期 yyyyMMdd
    private String startDate;

    //结束日期 yyyyMMdd
    private String endDate;

    //原交易类型：
    //4641-充值
    //4643-提现
    //4645-代付
    //4651-线下转账
    //充值（银行电子
    //账户）
    //4653-线下转账
    //充值（中金电子
    //记账簿）
    //5011-综合支付
    //5021-退款
    //5031-延迟分账
    //5041-分账回退
    private String sourceTxType;

    //交易主流水号 请求交易时的主单流水号，如
    //5011/5012/5021/5031/4641/4643
    //接口的<TxSN>
    private String mainTxSN;

    //交易流水号 有子单时为子单流水号；若无子单
    //为交易主流水号；
    //如：5011-<TxSN>
    private String txSN;

    //支付流水号 支付、分账、退款的关联单号，如
    //5011/5012 接口的<TxSN>，
    //5031/5021 接口的
    //<PaymentTxSN>
    private String payTxSN;

    //收支标识：
    //10=收
    //20=支
    //30=冻结
    //40=冲正
    //50=在途结转
    //60=解冻
    private String operation;


    private String pageIndex;
    //分页大小 注：最大 100 -> 1000 条
    private String pageSize;

    @Override
    public void process() throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        Element Request = document.createElement("Request");
        Element Head = document.createElement("Head");
        Element Body = document.createElement("Body");
        Element TxCode = document.createElement("TxCode");
        Element InstitutionID = document.createElement("InstitutionID");
        Element UserID = document.createElement("UserID");
        Element startDate = document.createElement("StartDate");
        startDate.setTextContent(this.startDate);
        Element endDate = document.createElement("EndDate");
        endDate.setTextContent(this.endDate);
        Element sourceTxType = document.createElement("SourceTxType");
        sourceTxType.setTextContent(this.sourceTxType);
        Element mainTxSN = document.createElement("MainTxSN");
        mainTxSN.setTextContent(this.mainTxSN);
        Element txSN = document.createElement("TxSN");
        txSN.setTextContent(this.txSN);
        Element payTxSN = document.createElement("PayTxSN");
        payTxSN.setTextContent(this.payTxSN);
        Element operation = document.createElement("Operation");
        operation.setTextContent(this.operation);
        Element pageIndex = document.createElement("PageIndex");
        pageIndex.setTextContent(this.pageIndex);
        Element pageSize = document.createElement("PageSize");
        pageSize.setTextContent(this.pageSize);
        document.appendChild(Request);
        Request.setAttribute("version", "2.1");
        Request.appendChild(Head);
        Head.appendChild(TxCode);
        TxCode.setTextContent(this.txCode);
        Request.appendChild(Body);
        Body.appendChild(InstitutionID);
        InstitutionID.setTextContent(cpcnConfig.getInstitutionID());
        Body.appendChild(UserID);
        Body.appendChild(startDate);
        Body.appendChild(endDate);
        Body.appendChild(sourceTxType);
        Body.appendChild(mainTxSN);
        Body.appendChild(txSN);
        Body.appendChild(payTxSN);
        Body.appendChild(operation);
        Body.appendChild(pageIndex);
        Body.appendChild(pageSize);
        UserID.setTextContent(this.userID);
        postProcess(document);
    }
}
