package com.biz.crm.cpcnpay.core.tx.foundationaccount;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.biz.crm.cpcnpay.common.utils.XmlUtils;
import com.biz.crm.cpcnpay.core.common.constant.Constants;
import com.biz.crm.cpcnpay.core.config.CpcnConfig;
import com.biz.crm.cpcnpay.core.tx.TxBaseResponse;
import lombok.Getter;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Getter
public class Tx4692Response extends TxBaseResponse {

    /**
     * 用户名称
     */
    private String userName;
    /**
     * 用户 ID
     */
    private String userID;

    //用户类型：
    //11=个人
    //12=企业
    //13 个体工商
    private String userType;

    private String institutionID;

    //电子账户号码 注：银行存管时返回
    private String eAccountNumber;

    //记录总条数
    private String totalCount;

    //记录总页数
    private String totalPage;

    //当前页码
    private String currentPage;

    private JSONArray item;


    @Override
    protected void process(Document document) throws Exception {
        if (Constants.SUCCESS_CODE.equals(this.code)) {
            this.userName = XmlUtils.getNodeText(document, "UserName");
            this.userID = XmlUtils.getNodeText(document, "UserID");
            this.userType = XmlUtils.getNodeText(document, "UserType");
            this.institutionID = XmlUtils.getNodeText(document, "InstitutionID");
            this.eAccountNumber = XmlUtils.getNodeText(document, "EAccountNumber");
            this.totalCount = XmlUtils.getNodeText(document, "TotalCount");
            this.totalPage = XmlUtils.getNodeText(document, "TotalPage");
            this.currentPage = XmlUtils.getNodeText(document, "CurrentPage");
            NodeList nodeList = document.getElementsByTagName("Item");
            if (nodeList != null && nodeList.getLength()>0) {
                JSONArray array=new JSONArray();
                for(int i=0;i<nodeList.getLength();i++){
                    Node item = nodeList.item(i);
                    NodeList childNodes = item.getChildNodes();
                    if(childNodes!=null&&childNodes.getLength()>0) {
                        JSONObject jsonObject = new JSONObject();
                        for (int childIndex = 0; childIndex < childNodes.getLength(); childIndex++) {
                            jsonObject.put(childNodes.item(childIndex).getNodeName(), childNodes.item(childIndex).getTextContent());
                        }
                        array.add(jsonObject);
                    }
                }
                this.item=array;
            }else{
                this.item=new JSONArray();
            }
        }
    }

    public Tx4692Response(String responseMessage, String responseSignature, CpcnConfig cpcnConfig) throws Exception {
        super(responseMessage, responseSignature, cpcnConfig);
    }
}
