package com.biz.crm.cpcnpay.core.tx.foundationaccount;

import com.biz.crm.cpcnpay.common.utils.XmlUtils;
import com.biz.crm.cpcnpay.core.common.constant.Constants;
import com.biz.crm.cpcnpay.core.config.CpcnConfig;
import com.biz.crm.cpcnpay.core.tx.TxBaseResponse;
import lombok.Getter;
import org.w3c.dom.Document;


/**
 * 4698-电子回单下载 响应报文
 *
 * @author Keller
 */
@Getter
public class Tx4698Response extends TxBaseResponse {

  /**
   * 交易状态; 10=成功 20=失败
   */
  private String status;

  /**
   * 下载地址
   */
  private String downLoadURL;

  /**
   * 响应代码
   */
  private String responseCode;

  /**
   * 响应消息
   */
  private String responseMessage;

  public Tx4698Response(String responseMessage, String responseSignature, CpcnConfig cpcnConfig) throws Exception {
    super(responseMessage, responseSignature, cpcnConfig);
  }

  @Override
  protected void process(Document document) throws Exception {
    if (Constants.SUCCESS_CODE.equals(this.code)) {
      this.status = XmlUtils.getNodeText(document, "Status");
      this.downLoadURL = XmlUtils.getNodeText(document, "DownLoadURL");
      this.responseCode = XmlUtils.getNodeText(document, "ResponseCode");
      this.responseMessage = XmlUtils.getNodeText(document, "ResponseMessage");
    }
  }

}
