package com.biz.crm.cpcnpay.core.vo;

import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

/**
 * 中金接口文件附件信息
 *
 * @author Keller
 */
@Getter
@Setter
@ToString
public class AttachInfo {
  /**
   * 支付类别
   * 00-正扫
   * 01-反扫
   * 10-APP
   * 11-JSAPI
   * 12-小程序
   * 13-H5
   */
  private String payType;
  /**
   * 当使用 JSAPI、小程序时此字段必填
   */
  private String appID;
  /**
   * 当开通微信公众号支付时此字段必填,最多可填写5个路径，不同的路径使用英文逗号分隔
   */
  private String authPath;
}
