/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cpcnpay.common.http;

import com.biz.crm.cpcnpay.common.http.IgnoreHostnameVerifier;
import com.biz.crm.cpcnpay.common.utils.PayUtils;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public class SecurityContext {
    public static SSLContext sslContext;
    public static SSLSocketFactory sslSocketFactory;

    public static void initSSLSocketFactory(String protocol, String keyStore, String keyStoreType, String keyStorePassword, String trustKeyStore, String trustKeyStoreType, String trustKeyStorePassword) throws Exception {
        KeyManager[] kms = PayUtils.getKeyManagers(keyStore, keyStoreType, keyStorePassword);
        TrustManager[] tms = PayUtils.getTrustManagers(trustKeyStore, trustKeyStoreType, trustKeyStorePassword);
        sslContext = SSLContext.getInstance(protocol);
        sslContext.init(kms, tms, null);
        sslSocketFactory = sslContext.getSocketFactory();
    }

    public static void initSSLSocketFactory(String trustKeyStore, String trustKeyStorePassword) throws Exception {
        TrustManager[] tms = PayUtils.getTrustManagers(trustKeyStore, "JKS", trustKeyStorePassword);
        sslContext = SSLContext.getInstance("TLS");
        sslContext.init(null, tms, null);
        sslSocketFactory = sslContext.getSocketFactory();
    }

    public static void initSSLSocketFactory(String protocol) throws Exception {
        sslContext = SSLContext.getInstance(protocol);
        sslContext.init(null, null, null);
        sslSocketFactory = sslContext.getSocketFactory();
    }

    public static void setIgnoreHostname(boolean ignoreHostname) {
        if (ignoreHostname) {
            HttpsURLConnection.setDefaultHostnameVerifier(new IgnoreHostnameVerifier());
        }
    }
}

