/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cpcnpay.core.service.internal;

import com.alibaba.fastjson.JSON;
import com.biz.crm.cpcnpay.core.config.CpcnConfig;
import com.biz.crm.cpcnpay.core.notice.NoticeRequest;
import com.biz.crm.cpcnpay.core.service.NoticeService;
import com.biz.crm.cpcnpay.core.strategy.notice.NoticeManager;
import com.biz.crm.cpcnpay.core.strategy.notice.NoticeStrategy;
import com.biz.crm.cpcnpay.core.vo.NoticeInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class NoticeServiceImpl
implements NoticeService {
    private static final Logger log = LoggerFactory.getLogger(NoticeServiceImpl.class);
    @Autowired
    private NoticeManager noticeManager;
    @Autowired
    private CpcnConfig cpcnConfig;

    @Override
    public void handlerNotice(NoticeInfo info) {
        try {
            log.error("\u4e2d\u91d1\u539f\u59cb\u4fe1\u606f:{}", (Object)info.getMessage());
            log.error("\u4e2d\u91d1\u539f\u59cb\u7b7e\u540d:{}", (Object)info.getSignature());
            NoticeRequest noticeRequest = new NoticeRequest(info.getMessage(), info.getSignature(), this.cpcnConfig);
            log.error("\u4e2d\u91d1\u56de\u8c03\u4fe1\u606f:{}", (Object)noticeRequest.getPlainText());
            NoticeStrategy service = this.noticeManager.getHandler(noticeRequest.getTxCode());
            Assert.notNull((Object)service, (String)String.format("\u83b7\u53d6\u4e2d\u91d1\u56de\u8c03\u5904\u7406\u5668\u4e3a\u7a7a:[%s]", noticeRequest.getTxCode()));
            service.handler(noticeRequest);
            log.error("\u4e2d\u91d1\u56de\u8c03\u5904\u7406\u7ed3\u675f\uff1a{}", (Object)JSON.toJSONString((Object)noticeRequest));
        }
        catch (Exception e) {
            log.error("\u5904\u7406\u4e2d\u91d1\u56de\u8c03\u6570\u636e\u51fa\u73b0\u9519\u8bef", (Throwable)e);
            throw new IllegalArgumentException(e.getMessage());
        }
    }
}

