/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cpcnpay.core.strategy.notice.internal;

import com.biz.crm.cpcnpay.core.common.enums.CpcnNoticeType;
import com.biz.crm.cpcnpay.core.notice.Notice5028Request;
import com.biz.crm.cpcnpay.core.notice.NoticeRequest;
import com.biz.crm.cpcnpay.core.service.notifier.Notice5028Listener;
import com.biz.crm.cpcnpay.core.strategy.notice.NoticeStrategy;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class Notice5028Strategy
implements NoticeStrategy<Notice5028Request> {
    private static final Logger log = LoggerFactory.getLogger(Notice5028Strategy.class);
    @Autowired(required=false)
    private List<Notice5028Listener> notice5028Listeners;

    @Override
    public String getCode() {
        return CpcnNoticeType.NOTICE_5028.getCode();
    }

    @Override
    public Notice5028Request exchange(NoticeRequest request) throws Exception {
        return new Notice5028Request(request.getDocument());
    }

    @Override
    public void handler(NoticeRequest request) {
        try {
            Notice5028Request notice5028Request = this.exchange(request);
            if (!CollectionUtils.isEmpty(this.notice5028Listeners)) {
                for (Notice5028Listener listener : this.notice5028Listeners) {
                    listener.onNotice(notice5028Request);
                }
            }
        }
        catch (Exception e) {
            log.error("\u652f\u4ed8\u901a\u77e5\u51fa\u73b0\u9519\u8bef", (Throwable)e);
            throw new RuntimeException(e.getLocalizedMessage());
        }
    }
}

