/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cpcnpay.core.strategy.notice.internal;

import com.biz.crm.cpcnpay.core.common.enums.CpcnNoticeType;
import com.biz.crm.cpcnpay.core.notice.Notice5088Request;
import com.biz.crm.cpcnpay.core.notice.NoticeRequest;
import com.biz.crm.cpcnpay.core.service.notifier.Notice5088Listener;
import com.biz.crm.cpcnpay.core.strategy.notice.NoticeStrategy;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class Notice5088Strategy
implements NoticeStrategy<Notice5088Request> {
    private static final Logger log = LoggerFactory.getLogger(Notice5088Strategy.class);
    @Autowired(required=false)
    private List<Notice5088Listener> notice5088Listeners;

    @Override
    public String getCode() {
        return CpcnNoticeType.NOTICE_5088.getCode();
    }

    @Override
    public Notice5088Request exchange(NoticeRequest request) throws Exception {
        return new Notice5088Request(request.getDocument());
    }

    @Override
    public void handler(NoticeRequest request) {
        try {
            Notice5088Request notice5088Request = this.exchange(request);
            if (!CollectionUtils.isEmpty(this.notice5088Listeners)) {
                for (Notice5088Listener listener : this.notice5088Listeners) {
                    listener.onNotice(notice5088Request);
                }
            }
        }
        catch (Exception e) {
            log.error("\u51bb\u7ed3\u8ba2\u5355\u5206\u8d26\u64a4\u9500\u901a\u77e5\u51fa\u73b0\u9519\u8bef", (Throwable)e);
            throw new RuntimeException(e.getLocalizedMessage());
        }
    }
}

