/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.admin.web.service.internal;

import com.biz.crm.admin.web.service.RewardRelTriggerObjectVoService;
import com.biz.crm.cps.business.reward.sdk.service.observer.RewardRelTriggerObjectServiceObserver;
import com.biz.crm.cps.business.reward.sdk.vo.RewardRelTriggerObjectItemVo;
import com.biz.crm.cps.business.reward.sdk.vo.RewardRelTriggerObjectVo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class RewardRelTriggerObjectVoServiceImpl
implements RewardRelTriggerObjectVoService {
    @Autowired(required=false)
    private List<RewardRelTriggerObjectServiceObserver> triggerObjectServiceObservers;

    @Override
    public List<RewardRelTriggerObjectVo> findByTriggerActionAndTriggerObjects(String triggerAction, List<String> triggerObjects) {
        if (CollectionUtils.isEmpty(triggerObjects) || StringUtils.isBlank((CharSequence)triggerAction) || CollectionUtils.isEmpty(this.triggerObjectServiceObservers)) {
            return null;
        }
        ArrayList relList = Lists.newArrayList();
        ArrayList list = Lists.newArrayList();
        for (RewardRelTriggerObjectServiceObserver rewardServiceObserver : this.triggerObjectServiceObservers) {
            List itemRels = rewardServiceObserver.onRequestRewardRelTriggerObjectItems(triggerAction, triggerObjects);
            if (CollectionUtils.isEmpty((Collection)itemRels)) continue;
            list.addAll(itemRels);
        }
        Map<String, List<RewardRelTriggerObjectItemVo>> relMap = list.stream().collect(Collectors.groupingBy(RewardRelTriggerObjectItemVo::getTriggerObject));
        for (Map.Entry<String, List<RewardRelTriggerObjectItemVo>> entry : relMap.entrySet()) {
            RewardRelTriggerObjectVo vo = new RewardRelTriggerObjectVo();
            vo.setTriggerObject(entry.getKey());
            List<RewardRelTriggerObjectItemVo> itemVos = entry.getValue();
            List rewardTypeStatisticsVos = itemVos.stream().map(RewardRelTriggerObjectItemVo::getRewardStatisticsVo).collect(Collectors.toList());
            vo.setRewardTypeStatisticsVos(rewardTypeStatisticsVos);
            relList.add(vo);
        }
        return relList;
    }
}

