/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.admin.web.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.admin.web.dto.DisplayTaskReportDto;
import com.biz.crm.admin.web.mapper.DisplayPolicyReportMapper;
import com.biz.crm.admin.web.vo.DisplayTaskReportVo;
import com.biz.crm.cps.bisiness.policy.display.sdk.common.enums.DisplayTaskStatusEnum;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class DisplayPolicyReportRepository {
    @Resource
    private DisplayPolicyReportMapper displayPolicyReportMapper;

    public Integer findDisplayStatisticsReportByTenant(String tenantCode, Date monthStartTime, Date monthEndTime, String taskStatus) {
        return this.displayPolicyReportMapper.findDisplayStatisticsReportByTenant(tenantCode, monthStartTime, monthEndTime, taskStatus);
    }

    public Page<DisplayTaskReportVo> findByConditions(Pageable pageable, DisplayTaskReportDto dto) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        ArrayList taskStatusList = Lists.newArrayList();
        if (DisplayTaskStatusEnum.STATUS_WAIT.getDictCode().equals(dto.getTaskStatus())) {
            taskStatusList.add(DisplayTaskStatusEnum.STATUS_WAIT.getDictCode());
            taskStatusList.add(DisplayTaskStatusEnum.STATUS_AI_REJECT.getDictCode());
            taskStatusList.add(DisplayTaskStatusEnum.STATUS_MANUALLY_REVIEW.getDictCode());
        } else if (DisplayTaskStatusEnum.STATUS_NOT_PASS.getDictCode().equals(dto.getTaskStatus())) {
            taskStatusList.add(DisplayTaskStatusEnum.STATUS_NOT_PASS.getDictCode());
            taskStatusList.add(DisplayTaskStatusEnum.STATUS_OVERDUE.getDictCode());
        } else if (DisplayTaskStatusEnum.STATUS_PASS.getDictCode().equals(dto.getTaskStatus())) {
            taskStatusList.add(DisplayTaskStatusEnum.STATUS_PASS.getDictCode());
            taskStatusList.add(DisplayTaskStatusEnum.STATUS_OVERDUE_NOT_AUDIT.getDictCode());
        } else if (StringUtils.isNotBlank((CharSequence)dto.getTaskStatus())) {
            taskStatusList.add(dto.getTaskStatus());
        }
        return this.displayPolicyReportMapper.findByConditions((Page<DisplayTaskReportVo>)page, dto, taskStatusList);
    }
}

