/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.admin.web.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.admin.web.dto.DisplayTaskReportDto;
import com.biz.crm.admin.web.repository.DisplayPolicyReportRepository;
import com.biz.crm.admin.web.service.DisplayPolicyReportService;
import com.biz.crm.admin.web.service.RewardRelTriggerObjectVoService;
import com.biz.crm.admin.web.service.RewardTypeStatisticsVoService;
import com.biz.crm.admin.web.vo.DisplayStatisticsReportVo;
import com.biz.crm.admin.web.vo.DisplayTaskReportVo;
import com.biz.crm.cps.bisiness.policy.display.sdk.common.enums.DisplayTaskStatusEnum;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class DisplayPolicyReportServiceImpl
implements DisplayPolicyReportService {
    @Autowired
    private DisplayPolicyReportRepository displayPolicyReportRepository;
    @Autowired
    private RewardTypeStatisticsVoService rewardTypeStatisticsVoService;
    @Autowired
    private RewardRelTriggerObjectVoService rewardRelTriggerObjectVoService;

    @Override
    public DisplayStatisticsReportVo findDisplayStatisticsReportByTenant() {
        DisplayStatisticsReportVo displayStatisticsReportVo = new DisplayStatisticsReportVo();
        Calendar cal = Calendar.getInstance();
        cal.set(cal.get(1), cal.get(2), cal.get(5), 0, 0, 0);
        cal.set(5, cal.getActualMinimum(5));
        Date monthStartTime = cal.getTime();
        cal.set(cal.get(1), cal.get(2), cal.get(5), 0, 0, 0);
        cal.set(5, cal.getActualMaximum(5));
        cal.set(11, 24);
        Date monthEndTime = cal.getTime();
        displayStatisticsReportVo.setExecutionTerminalNumbers(this.displayPolicyReportRepository.findDisplayStatisticsReportByTenant(TenantUtils.getTenantCode(), monthStartTime, monthEndTime, null));
        displayStatisticsReportVo.setFinishTerminalNumbers(this.displayPolicyReportRepository.findDisplayStatisticsReportByTenant(TenantUtils.getTenantCode(), monthStartTime, monthEndTime, DisplayTaskStatusEnum.STATUS_PASS.getDictCode()));
        displayStatisticsReportVo.setRewardTypeStatisticsVos(this.rewardTypeStatisticsVoService.findByTenantCodeAndTriggerAction(TenantUtils.getTenantCode(), "display"));
        return displayStatisticsReportVo;
    }

    @Override
    public Page<DisplayTaskReportVo> findByConditions(Pageable pageable, DisplayTaskReportDto dto) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (dto == null) {
            dto = new DisplayTaskReportDto();
        }
        Page<DisplayTaskReportVo> page = this.displayPolicyReportRepository.findByConditions(pageable, dto);
        return page;
    }
}

