/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.admin.web.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.admin.web.dto.AgreementRewardDto;
import com.biz.crm.admin.web.service.AgreementReportVoService;
import com.biz.crm.admin.web.service.AgreementRewardVoService;
import com.biz.crm.admin.web.vo.AgreementReportVo;
import com.biz.crm.admin.web.vo.AgreementRewardVo;
import com.biz.crm.cps.business.agreement.sdk.service.AgreementVoService;
import com.biz.crm.cps.business.agreement.sdk.vo.AgreementVo;
import com.biz.crm.cps.business.consumer.sdk.service.ConsumerVoService;
import com.biz.crm.cps.business.consumer.sdk.vo.ConsumerVo;
import com.biz.crm.cps.business.participator.sdk.common.enums.ParticipatorTypeEnum;
import com.biz.crm.cps.business.reward.cost.local.entity.CostDealerEntity;
import com.biz.crm.cps.business.reward.cost.local.entity.CostTerminalEntity;
import com.biz.crm.cps.business.reward.cost.local.service.CostDealerService;
import com.biz.crm.cps.business.reward.cost.local.service.CostTerminalService;
import com.biz.crm.cps.business.reward.integral.local.entity.IntegralEntity;
import com.biz.crm.cps.business.reward.integral.local.service.IntegralService;
import com.biz.crm.cps.business.reward.redpacket.local.entity.RedPacketEntity;
import com.biz.crm.cps.business.reward.redpacket.local.service.RedPacketService;
import com.biz.crm.cps.external.barcode.sdk.dto.ScanCodeRecordStatisticsDto;
import com.biz.crm.cps.external.barcode.sdk.service.ScanCodeRecordVoService;
import java.math.BigDecimal;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class AgreementReportVoServiceImpl
implements AgreementReportVoService {
    @Autowired
    private AgreementVoService agreementVoService;
    @Autowired
    private RedPacketService redPacketService;
    @Autowired
    private ConsumerVoService consumerVoService;
    @Autowired
    private CostDealerService costDealerService;
    @Autowired
    private CostTerminalService costTerminalService;
    @Autowired
    private IntegralService integralService;
    @Autowired
    private ScanCodeRecordVoService scanCodeRecordVoService;
    @Autowired
    private AgreementRewardVoService agreementRewardVoService;

    @Override
    public AgreementReportVo findAgreementAndType(String code, String type) {
        if (StringUtils.isBlank((CharSequence)code) || StringUtils.isBlank((CharSequence)type)) {
            return null;
        }
        AgreementReportVo vo = new AgreementReportVo();
        vo.setCashTotal(BigDecimal.ZERO);
        vo.setOrderTotal(BigDecimal.ZERO);
        vo.setOrderAmountTotal(BigDecimal.ZERO);
        AgreementVo agreementVo = this.agreementVoService.findByAgreementCode(code);
        if (agreementVo == null) {
            return null;
        }
        AgreementRewardDto rewardDto = new AgreementRewardDto();
        rewardDto.setCode(code);
        rewardDto.setType(type);
        Page<AgreementRewardVo> conditions = this.agreementRewardVoService.findByConditions((Pageable)PageRequest.of((int)0, (int)50), rewardDto);
        if (conditions != null) {
            vo.setNumber((int)conditions.getTotal());
        } else {
            vo.setNumber(0);
        }
        if (ParticipatorTypeEnum.DEALER.getDictCode().equals(type)) {
            this.buildVo(vo, agreementVo.getCustomerCode(), type);
        }
        if (ParticipatorTypeEnum.TERMINAL.getDictCode().equals(type)) {
            this.buildVo(vo, agreementVo.getTerminalCode(), type);
        }
        if (ParticipatorTypeEnum.CONSUMER.getDictCode().equals(type)) {
            List consumers = this.consumerVoService.findByTerminalCode(agreementVo.getTerminalCode());
            BigDecimal cashTotal = BigDecimal.ZERO;
            BigDecimal costTotal = BigDecimal.ZERO;
            BigDecimal integralTotal = BigDecimal.ZERO;
            Integer number = 0;
            BigDecimal orderAmountTotal = BigDecimal.ZERO;
            BigDecimal redPacketTotal = BigDecimal.ZERO;
            BigDecimal orderTotal = BigDecimal.ZERO;
            BigDecimal scanTotal = BigDecimal.ZERO;
            for (ConsumerVo consumerVo : consumers) {
                this.buildVo(vo, consumerVo.getConsumerCode(), type);
                cashTotal = cashTotal.add(vo.getCashTotal() == null ? BigDecimal.ZERO : vo.getCashTotal());
                costTotal = costTotal.add(vo.getCostTotal() == null ? BigDecimal.ZERO : vo.getCostTotal());
                integralTotal = integralTotal.add(vo.getIntegralTotal() == null ? BigDecimal.ZERO : vo.getIntegralTotal());
                number = number + (vo.getNumber() == null ? 0 : vo.getNumber());
                orderAmountTotal = orderAmountTotal.add(vo.getOrderAmountTotal() == null ? BigDecimal.ZERO : vo.getOrderAmountTotal());
                redPacketTotal = redPacketTotal.add(vo.getRedPacketTotal() == null ? BigDecimal.ZERO : vo.getRedPacketTotal());
                orderTotal = orderTotal.add(vo.getOrderTotal() == null ? BigDecimal.ZERO : vo.getOrderTotal());
                scanTotal = scanTotal.add(vo.getScanTotal() == null ? BigDecimal.ZERO : vo.getScanTotal());
            }
            vo.setNumber(number);
            vo.setOrderAmountTotal(orderAmountTotal);
            vo.setOrderTotal(orderTotal);
            vo.setCashTotal(cashTotal);
            vo.setCostTotal(costTotal);
            vo.setIntegralTotal(integralTotal);
            vo.setRedPacketTotal(redPacketTotal);
            vo.setScanTotal(scanTotal);
        }
        return vo;
    }

    @Override
    public AgreementReportVo findByAgreementCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        AgreementReportVo dealer = this.findAgreementAndType(code, "1");
        AgreementReportVo terminal = this.findAgreementAndType(code, "2");
        AgreementReportVo cus = this.findAgreementAndType(code, "3");
        AgreementReportVo vo = new AgreementReportVo();
        BigDecimal costTotal = BigDecimal.ZERO;
        BigDecimal integralTotal = BigDecimal.ZERO;
        BigDecimal redPacketTotal = BigDecimal.ZERO;
        BigDecimal scanTotal = BigDecimal.ZERO;
        if (dealer != null) {
            costTotal = costTotal.add(dealer.getCostTotal() == null ? BigDecimal.ZERO : dealer.getCostTotal());
            integralTotal = integralTotal.add(dealer.getIntegralTotal() == null ? BigDecimal.ZERO : dealer.getIntegralTotal());
            redPacketTotal = redPacketTotal.add(dealer.getRedPacketTotal() == null ? BigDecimal.ZERO : dealer.getRedPacketTotal());
            scanTotal = scanTotal.add(dealer.getScanTotal() == null ? BigDecimal.ZERO : dealer.getScanTotal());
        }
        if (terminal != null) {
            costTotal = costTotal.add(dealer.getCostTotal() == null ? BigDecimal.ZERO : dealer.getCostTotal());
            integralTotal = integralTotal.add(dealer.getIntegralTotal() == null ? BigDecimal.ZERO : dealer.getIntegralTotal());
            redPacketTotal = redPacketTotal.add(dealer.getRedPacketTotal() == null ? BigDecimal.ZERO : dealer.getRedPacketTotal());
            scanTotal = scanTotal.add(dealer.getScanTotal() == null ? BigDecimal.ZERO : dealer.getScanTotal());
        }
        if (cus != null) {
            costTotal = costTotal.add(dealer.getCostTotal() == null ? BigDecimal.ZERO : dealer.getCostTotal());
            integralTotal = integralTotal.add(dealer.getIntegralTotal() == null ? BigDecimal.ZERO : dealer.getIntegralTotal());
            redPacketTotal = redPacketTotal.add(dealer.getRedPacketTotal() == null ? BigDecimal.ZERO : dealer.getRedPacketTotal());
            scanTotal = scanTotal.add(dealer.getScanTotal() == null ? BigDecimal.ZERO : dealer.getScanTotal());
        }
        vo.setScanTotal(scanTotal);
        vo.setCostTotal(costTotal);
        vo.setIntegralTotal(integralTotal);
        vo.setRedPacketTotal(redPacketTotal);
        return vo;
    }

    private void buildVo(AgreementReportVo vo, String code, String type) {
        IntegralEntity integral;
        RedPacketEntity redPacket = this.redPacketService.findByParticipatorCode(code);
        if (redPacket != null) {
            vo.setRedPacketTotal(redPacket.getAccruingRedPacket() == null ? BigDecimal.ZERO : redPacket.getAccruingRedPacket());
        } else {
            vo.setRedPacketTotal(BigDecimal.ZERO);
        }
        if (ParticipatorTypeEnum.DEALER.getDictCode().equals(type)) {
            CostDealerEntity dealer = this.costDealerService.findByDealerCode(code);
            if (dealer != null) {
                vo.setCostTotal(dealer.getTotalAmount() == null ? BigDecimal.ZERO : dealer.getTotalAmount());
            } else {
                vo.setCostTotal(BigDecimal.ZERO);
            }
        }
        if (ParticipatorTypeEnum.TERMINAL.getDictCode().equals(type)) {
            CostTerminalEntity terminal = this.costTerminalService.findByTerminalCode(code);
            if (terminal != null) {
                vo.setCostTotal(terminal.getTotalAmount() == null ? BigDecimal.ZERO : terminal.getTotalAmount());
            } else {
                vo.setCostTotal(BigDecimal.ZERO);
            }
        }
        if ((integral = this.integralService.findByParticipatorCode(code)) != null) {
            vo.setIntegralTotal(integral.getAccruingIntegral() == null ? BigDecimal.ZERO : integral.getAccruingIntegral());
        } else {
            vo.setIntegralTotal(BigDecimal.ZERO);
        }
        ScanCodeRecordStatisticsDto dto = new ScanCodeRecordStatisticsDto();
        dto.setScanParticipatorCode(code);
        Integer integer = this.scanCodeRecordVoService.countByScanCodeRecordDto(dto);
        vo.setScanTotal(integer == null ? BigDecimal.ZERO : new BigDecimal(integer));
    }
}

