/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.admin.web.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.admin.web.dto.AgreementRewardDto;
import com.biz.crm.admin.web.repository.AgreementRewardVoRepository;
import com.biz.crm.admin.web.service.AgreementRewardVoService;
import com.biz.crm.admin.web.vo.AgreementRewardVo;
import com.biz.crm.cps.business.agreement.sdk.service.AgreementVoService;
import com.biz.crm.cps.business.agreement.sdk.vo.AgreementVo;
import com.biz.crm.cps.business.consumer.sdk.service.ConsumerVoService;
import com.biz.crm.cps.business.participator.sdk.common.enums.ParticipatorTypeEnum;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class AgreementRewardVoServiceImpl
implements AgreementRewardVoService {
    @Autowired
    private AgreementVoService agreementVoService;
    @Autowired
    private AgreementRewardVoRepository agreementRewardVoRepository;
    @Autowired
    private ConsumerVoService consumerVoService;

    @Override
    public Page<AgreementRewardVo> findByConditions(Pageable pageable, AgreementRewardDto agreementRewardDto) {
        if (agreementRewardDto == null || StringUtils.isBlank((CharSequence)agreementRewardDto.getType()) || StringUtils.isBlank((CharSequence)agreementRewardDto.getCode())) {
            return new Page();
        }
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        AgreementVo agreementVo = this.agreementVoService.findByAgreementCode(agreementRewardDto.getCode());
        if (agreementVo == null) {
            return new Page();
        }
        if (ParticipatorTypeEnum.DEALER.getDictCode().equals(agreementRewardDto.getType())) {
            agreementRewardDto.setParticipatorCodes(Arrays.asList(agreementVo.getCustomerCode()));
            return this.agreementRewardVoRepository.findByConditions(pageable, agreementRewardDto);
        }
        if (ParticipatorTypeEnum.TERMINAL.getDictCode().equals(agreementRewardDto.getType())) {
            agreementRewardDto.setParticipatorCodes(Arrays.asList(agreementVo.getTerminalCode()));
            return this.agreementRewardVoRepository.findByConditions(pageable, agreementRewardDto);
        }
        if (ParticipatorTypeEnum.CONSUMER.getDictCode().equals(agreementRewardDto.getType())) {
            List consumers = this.consumerVoService.findByTerminalCode(agreementVo.getTerminalCode());
            ArrayList<String> codes = new ArrayList<String>();
            consumers.stream().forEach(item -> codes.add(item.getConsumerCode()));
            agreementRewardDto.setParticipatorCodes(codes);
            return this.agreementRewardVoRepository.findByConditions(pageable, agreementRewardDto);
        }
        return new Page();
    }
}

