/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.admin.web.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.admin.web.dto.ConsumerReportDto;
import com.biz.crm.admin.web.dto.ConsumerTerminalMappingDto;
import com.biz.crm.admin.web.repository.ConsumerReportRepository;
import com.biz.crm.admin.web.service.ConsumerReportService;
import com.biz.crm.admin.web.service.ConsumerTerminalMappingReportService;
import com.biz.crm.admin.web.vo.ConsumerReportVo;
import com.biz.crm.admin.web.vo.ConsumerTerminalMappingReportVo;
import com.biz.crm.cps.business.common.sdk.vo.BaseIdVo;
import com.biz.crm.cps.external.barcode.sdk.dto.ScanCodeRecordStatisticsDto;
import com.biz.crm.cps.external.barcode.sdk.service.ScanCodeRecordVoService;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ConsumerReportServiceImpl
implements ConsumerReportService {
    @Autowired
    private ConsumerReportRepository consumerReportRepository;
    @Autowired
    private ScanCodeRecordVoService scanCodeRecordVoService;
    @Autowired
    private ConsumerTerminalMappingReportService consumerTerminalMappingReportService;

    @Override
    public Page<ConsumerReportVo> findByConditions(Pageable pageable, ConsumerReportDto dto) {
        Page<ConsumerReportVo> page;
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (dto == null) {
            dto = new ConsumerReportDto();
        }
        if (Objects.isNull(page = this.consumerReportRepository.findByConditions(pageable, dto))) {
            return null;
        }
        List list = page.getRecords();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            List<String> ids = list.stream().map(BaseIdVo::getId).collect(Collectors.toList());
            ConsumerTerminalMappingDto consumerTerminalMappingDto = new ConsumerTerminalMappingDto();
            consumerTerminalMappingDto.setConsumerIds(ids);
            List<ConsumerTerminalMappingReportVo> byConditions = this.consumerTerminalMappingReportService.findByConditions(consumerTerminalMappingDto);
            if (!CollectionUtils.isEmpty(byConditions)) {
                list.stream().forEach(consumerReportVo -> {
                    long count = byConditions.stream().filter(consumerTerminalMappingReportVo -> consumerReportVo.getId().equals(consumerTerminalMappingReportVo.getConsumerId())).count();
                    consumerReportVo.setInvolveTerminalCount(Long.valueOf(count).intValue());
                });
            }
        }
        return page;
    }

    @Override
    public ConsumerReportVo findDetailsByConsumerCode(String consumerCode) {
        if (StringUtils.isBlank((CharSequence)consumerCode)) {
            return null;
        }
        ConsumerReportVo consumerReportVo = this.consumerReportRepository.findDetailsByConsumerCode(consumerCode);
        if (Objects.isNull((Object)consumerReportVo)) {
            return null;
        }
        ScanCodeRecordStatisticsDto scanCodeRecordStatisticsDto = new ScanCodeRecordStatisticsDto();
        scanCodeRecordStatisticsDto.setScanParticipatorCode(consumerReportVo.getExternalId());
        Integer integer = this.scanCodeRecordVoService.countByScanCodeRecordDto(scanCodeRecordStatisticsDto);
        consumerReportVo.setScanCount(integer);
        return consumerReportVo;
    }
}

