/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.admin.web.service.internal;

import com.biz.crm.admin.web.service.RewardRelAgreementVoService;
import com.biz.crm.cps.business.reward.sdk.service.observer.RewardRelAgreementServiceObserver;
import com.biz.crm.cps.business.reward.sdk.vo.RewardRelAgreementItemVo;
import com.biz.crm.cps.business.reward.sdk.vo.RewardRelAgreementVo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class RewardRelAgreementVoServiceImpl
implements RewardRelAgreementVoService {
    @Autowired(required=false)
    private List<RewardRelAgreementServiceObserver> rewardRelAgreementServiceObservers;

    @Override
    public List<RewardRelAgreementVo> findByParticipatorCodeAndTemplateCodes(String participatorCode, List<String> templateCodes) {
        if (CollectionUtils.isEmpty(templateCodes) || StringUtils.isBlank((CharSequence)participatorCode) || CollectionUtils.isEmpty(this.rewardRelAgreementServiceObservers)) {
            return null;
        }
        ArrayList relList = Lists.newArrayList();
        ArrayList list = Lists.newArrayList();
        for (RewardRelAgreementServiceObserver rewardServiceObserver : this.rewardRelAgreementServiceObservers) {
            List itemRels = rewardServiceObserver.onRequestRewardRelAgreementItems(participatorCode, templateCodes);
            if (CollectionUtils.isEmpty((Collection)itemRels)) continue;
            list.addAll(itemRels);
        }
        Map<String, List<RewardRelAgreementItemVo>> relMap = list.stream().filter(item -> Objects.nonNull(item.getTemplateCode())).collect(Collectors.groupingBy(RewardRelAgreementItemVo::getTemplateCode));
        for (Map.Entry<String, List<RewardRelAgreementItemVo>> entry : relMap.entrySet()) {
            RewardRelAgreementVo vo = new RewardRelAgreementVo();
            vo.setTemplateCode(entry.getKey());
            List<RewardRelAgreementItemVo> itemVos = entry.getValue();
            List rewardTypeStatisticsVos = itemVos.stream().map(RewardRelAgreementItemVo::getRewardStatisticsVo).collect(Collectors.toList());
            vo.setRewardTypeStatisticsVos(rewardTypeStatisticsVos);
            relList.add(vo);
        }
        return relList;
    }
}

