/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.admin.web.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.admin.web.dto.ScanCodeRecordReportDto;
import com.biz.crm.admin.web.repository.ScanCodeRecordReportRepository;
import com.biz.crm.admin.web.service.ScanCodeRecordReportService;
import com.biz.crm.admin.web.vo.ScanCodeCostReqVo;
import com.biz.crm.admin.web.vo.ScanCodeCostRespVo;
import com.biz.crm.admin.web.vo.ScanCodeRecordReportVo;
import com.biz.crm.cps.business.participator.sdk.common.enums.ParticipatorTypeEnum;
import com.biz.crm.cps.business.policy.quantify.local.entity.QuantifyConfiguration;
import com.biz.crm.cps.business.policy.quantify.local.entity.QuantifyPolicy;
import com.biz.crm.cps.business.policy.quantify.local.entity.QuantifyRange;
import com.biz.crm.cps.business.policy.quantify.local.entity.QuantifyTask;
import com.biz.crm.cps.business.policy.quantify.local.service.QuantifyPolicyService;
import com.biz.crm.cps.business.policy.quantify.local.service.QuantifyTaskService;
import com.biz.crm.cps.business.product.sdk.dto.MaterialStandardUnitDto;
import com.biz.crm.cps.business.product.sdk.service.MaterialStandardUnitVoService;
import com.biz.crm.cps.business.product.sdk.service.MaterialVoService;
import com.biz.crm.cps.business.product.sdk.vo.MaterialStandardUnitVo;
import com.biz.crm.cps.business.reward.sdk.vo.ScanCodeRewardStatisticsVo;
import com.biz.crm.cps.external.barcode.sdk.service.ScanCodeRecordVoService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ScanCodeRecordReportServiceImpl
implements ScanCodeRecordReportService {
    @Resource
    private ScanCodeRecordReportRepository scanCodeRecordReportRepository;
    @Autowired
    private QuantifyTaskService quantifyTaskService;
    @Autowired
    private QuantifyPolicyService quantifyPolicyService;
    @Autowired
    private ScanCodeRecordVoService scanCodeRecordVoService;
    @Autowired
    private MaterialVoService materialVoService;
    @Autowired
    private MaterialStandardUnitVoService materialStandardUnitVoService;

    @Override
    public Page<ScanCodeRecordReportVo> findByConditions(Pageable pageable, ScanCodeRecordReportDto dto) {
        Page<ScanCodeRecordReportVo> page;
        List records;
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (dto == null) {
            dto = new ScanCodeRecordReportDto();
        }
        if (!CollectionUtils.isEmpty((Collection)(records = (page = this.scanCodeRecordReportRepository.findByConditions(pageable, dto)).getRecords()))) {
            this.buildScanCodeList(records);
        }
        return page;
    }

    @Override
    public Page<ScanCodeRecordReportVo> findByQuantifyTaskBusinessCode(Pageable pageable, String quantifyTaskId) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (StringUtils.isBlank((CharSequence)quantifyTaskId)) {
            return null;
        }
        QuantifyTask quantifyTask = this.quantifyTaskService.findById(quantifyTaskId);
        if (!ObjectUtils.allNotNull((Object[])new Object[]{quantifyTask})) {
            return null;
        }
        QuantifyPolicy quantifyPolicy = this.quantifyPolicyService.findDetailByTemplateCode(quantifyTask.getTemplateId());
        if (!ObjectUtils.allNotNull((Object[])new Object[]{quantifyTask})) {
            return null;
        }
        ArrayList dimensionCodes = Lists.newArrayList();
        Map configurationMap = quantifyPolicy.getQuantifyConfigurations().stream().collect(Collectors.toMap(QuantifyConfiguration::getDimensionFlag, Function.identity()));
        if (!configurationMap.containsKey("DIMENSION_ALL")) {
            quantifyPolicy.getQuantifyConfigurations().forEach(configuration -> {
                List dimensions = configuration.getQuantifyRanges().stream().map(QuantifyRange::getSpecialCode).collect(Collectors.toList());
                List materialCodes = this.materialVoService.findMaterialCodeByDimensionCodesAndDimensionType(dimensions, configuration.getDimensionFlag());
                if (CollectionUtils.isEmpty((Collection)materialCodes)) {
                    dimensionCodes.addAll(materialCodes);
                }
            });
        }
        ScanCodeRecordReportDto scanCodeRecordReportDto = new ScanCodeRecordReportDto();
        scanCodeRecordReportDto.setParticipatorType(ParticipatorTypeEnum.TERMINAL.getKey());
        scanCodeRecordReportDto.setScanParticipatorCode(quantifyTask.getTerminalCode());
        scanCodeRecordReportDto.setCreateTimeStart(quantifyTask.getTaskStartTime());
        scanCodeRecordReportDto.setCreateTimeEnd(quantifyTask.getTaskEndTime());
        scanCodeRecordReportDto.setProductCodes(dimensionCodes);
        Page<ScanCodeRecordReportVo> page = this.scanCodeRecordReportRepository.findByConditions(pageable, scanCodeRecordReportDto);
        if (CollectionUtils.isEmpty((Collection)page.getRecords())) {
            return page;
        }
        this.buildScanCodeList(page.getRecords());
        ArrayList materialStandardUnitDtos = Lists.newArrayList();
        page.getRecords().forEach(scanCodeRecordVo -> {
            MaterialStandardUnitDto materialStandardUnitDto = new MaterialStandardUnitDto();
            materialStandardUnitDto.setMaterialCode(scanCodeRecordVo.getProductCode());
            materialStandardUnitDtos.add(materialStandardUnitDto);
        });
        List unitVos = this.materialStandardUnitVoService.findByMaterialCodeAndBarCodeType((List)materialStandardUnitDtos);
        if (CollectionUtils.isEmpty((Collection)unitVos)) {
            return page;
        }
        Map unitVoMap = unitVos.stream().collect(Collectors.toMap(MaterialStandardUnitVo::getMaterialCode, Function.identity()));
        page.getRecords().forEach(scanCodeRecordVo -> {
            MaterialStandardUnitVo unitVo = (MaterialStandardUnitVo)unitVoMap.get(scanCodeRecordVo.getProductCode());
            if (ObjectUtils.allNotNull((Object[])new Object[]{unitVo})) {
                scanCodeRecordVo.setProductName(unitVo.getMaterialName());
                scanCodeRecordVo.setStandardUnit(unitVo.getStandardUnit());
                scanCodeRecordVo.setStandardUnitDesc(unitVo.getStandardUnitDesc());
            }
        });
        return page;
    }

    @Override
    public Page<ScanCodeCostRespVo> findScanCodeCostPage(Pageable pageable, ScanCodeCostReqVo reqVo) {
        Page<ScanCodeCostRespVo> page;
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (reqVo == null) {
            reqVo = new ScanCodeCostReqVo();
        }
        if (!CollectionUtils.isEmpty((Collection)(page = this.scanCodeRecordReportRepository.findScanCodeCostPage(pageable, reqVo)).getRecords())) {
            ArrayList<String> recordCodeList = new ArrayList<String>();
            HashMap respVoMap = new HashMap();
            page.getRecords().forEach(item -> {
                recordCodeList.add(item.getRecordCode());
                respVoMap.put(item.getRecordCode(), item);
            });
            if (!CollectionUtils.isEmpty(recordCodeList)) {
                List<ScanCodeRewardStatisticsVo> costByRecordCodes;
                List<ScanCodeRewardStatisticsVo> integralByRecordCodes;
                List<ScanCodeRewardStatisticsVo> redPacketByRecordCodes = this.scanCodeRecordReportRepository.findRedPacketByRecordCodes(recordCodeList);
                if (!CollectionUtils.isEmpty(redPacketByRecordCodes)) {
                    redPacketByRecordCodes.forEach(item -> {
                        if (respVoMap.containsKey(item.getRecordCode())) {
                            ((ScanCodeCostRespVo)respVoMap.get(item.getRecordCode())).setRedPacket(item.getAmount());
                        }
                    });
                }
                if (!CollectionUtils.isEmpty(integralByRecordCodes = this.scanCodeRecordReportRepository.findIntegralByRecordCodes(recordCodeList))) {
                    integralByRecordCodes.forEach(item -> {
                        if (respVoMap.containsKey(item.getRecordCode())) {
                            ((ScanCodeCostRespVo)respVoMap.get(item.getRecordCode())).setIntegral(item.getAmount());
                        }
                    });
                }
                if (!CollectionUtils.isEmpty(costByRecordCodes = this.scanCodeRecordReportRepository.findCostByRecordCodes(recordCodeList))) {
                    costByRecordCodes.forEach(item -> {
                        if (respVoMap.containsKey(item.getRecordCode())) {
                            ((ScanCodeCostRespVo)respVoMap.get(item.getRecordCode())).setCost(item.getAmount());
                        }
                    });
                }
            }
        }
        return page;
    }

    private void buildScanCodeList(List<ScanCodeRecordReportVo> records) {
        records.stream().forEach(scanCodeRecordReportVo -> {
            if (ParticipatorTypeEnum.DEALER.getKey().equals(scanCodeRecordReportVo.getParticipatorType())) {
                scanCodeRecordReportVo.setChannelName(scanCodeRecordReportVo.getDealerChannelName());
                scanCodeRecordReportVo.setOrgName(scanCodeRecordReportVo.getDealerOrgName());
                scanCodeRecordReportVo.setCustomerCode(scanCodeRecordReportVo.getDealerCode());
                scanCodeRecordReportVo.setCustomerName(scanCodeRecordReportVo.getDealerName());
            }
            if (ParticipatorTypeEnum.TERMINAL.getKey().equals(scanCodeRecordReportVo.getParticipatorType())) {
                scanCodeRecordReportVo.setChannelName(scanCodeRecordReportVo.getTerminalChannelName());
                scanCodeRecordReportVo.setOrgName(scanCodeRecordReportVo.getTerminalOrgName());
                scanCodeRecordReportVo.setCustomerCode(scanCodeRecordReportVo.getTerminalCode());
                scanCodeRecordReportVo.setCustomerName(scanCodeRecordReportVo.getTerminalName());
            }
            if (ParticipatorTypeEnum.CONSUMER.getKey().equals(scanCodeRecordReportVo.getParticipatorType())) {
                scanCodeRecordReportVo.setCustomerCode(scanCodeRecordReportVo.getConsumerExternalId());
                scanCodeRecordReportVo.setCustomerName(scanCodeRecordReportVo.getConsumerNickname());
            }
        });
    }
}

