/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.admin.web.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.admin.web.service.RewardRelParticipatorVoService;
import com.biz.crm.admin.web.service.TerminalReportService;
import com.biz.crm.admin.web.vo.TerminalReportVo;
import com.biz.crm.cps.business.participator.local.entity.Terminal;
import com.biz.crm.cps.business.participator.local.service.TerminalService;
import com.biz.crm.cps.business.participator.sdk.dto.TerminalPaginationDto;
import com.biz.crm.cps.business.reward.sdk.vo.RewardRelParticipatorVo;
import com.biz.crm.cps.business.reward.sdk.vo.RewardTypeStatisticsVo;
import com.bizunited.platform.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class TerminalReportServiceImpl
implements TerminalReportService {
    @Autowired
    private TerminalService terminalService;
    @Autowired
    private RewardRelParticipatorVoService rewardRelParticipatorVoService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    @Override
    public Page<TerminalReportVo> findByConditions(Pageable pageable, TerminalPaginationDto terminalPaginationDto) {
        Page result = this.terminalService.findByConditions(pageable, terminalPaginationDto);
        List records = result.getRecords();
        Page page = new Page();
        page.setCurrent(result.getCurrent());
        page.setSize(result.getSize());
        page.setTotal(result.getTotal());
        if (CollectionUtils.isEmpty((Collection)records)) {
            return page;
        }
        Collection terminalReportVos = this.nebulaToolkitService.copyCollectionByBlankList((Iterable)records, Terminal.class, TerminalReportVo.class, HashSet.class, LinkedList.class, new String[0]);
        List<String> codeList = terminalReportVos.stream().map(TerminalReportVo::getTerminalCode).collect(Collectors.toList());
        List<RewardRelParticipatorVo> rewardRelParticipatorVoList = this.rewardRelParticipatorVoService.findByParticipatorCodes(codeList);
        if (CollectionUtils.isEmpty(rewardRelParticipatorVoList)) {
            page.setRecords((List)Lists.newLinkedList((Iterable)terminalReportVos));
            return page;
        }
        Map<String, List<RewardRelParticipatorVo>> codeMapVoList = rewardRelParticipatorVoList.stream().collect(Collectors.groupingBy(RewardRelParticipatorVo::getParticipatorCode));
        for (TerminalReportVo reportVo : terminalReportVos) {
            List<RewardRelParticipatorVo> rewardRelParticipatorVos = codeMapVoList.get(reportVo.getTerminalCode());
            if (CollectionUtils.isEmpty(rewardRelParticipatorVos)) continue;
            RewardRelParticipatorVo rewardRelParticipatorVo = rewardRelParticipatorVos.get(0);
            List rewardTypeStatisticsVos = rewardRelParticipatorVo.getRewardTypeStatisticsVos();
            for (RewardTypeStatisticsVo rewardTypeStatisticsVo : rewardTypeStatisticsVos) {
                String key = rewardTypeStatisticsVo.getKey();
                if ("cost".equals(key)) {
                    reportVo.setCumulativeCost(rewardTypeStatisticsVo.getAmount());
                    continue;
                }
                if ("integral".equals(key)) {
                    reportVo.setCumulativeIntegral(rewardTypeStatisticsVo.getAmount());
                    continue;
                }
                if (!"redpacket".equals(key)) continue;
                reportVo.setCumulativeRedpacket(rewardTypeStatisticsVo.getAmount());
            }
        }
        page.setRecords((List)Lists.newLinkedList((Iterable)terminalReportVos));
        return page;
    }
}

