/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.admin.web.service.internal;

import com.biz.crm.admin.web.service.RewardTypeStatisticsVoService;
import com.biz.crm.cps.business.reward.sdk.service.observer.RewardTypeStatisticsServiceObserver;
import com.biz.crm.cps.business.reward.sdk.vo.RewardTypeStatisticsVo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class RewardTypeStatisticsVoServiceImpl
implements RewardTypeStatisticsVoService {
    @Autowired(required=false)
    private List<RewardTypeStatisticsServiceObserver> rewardTypeStatisticsServiceObserverList;

    @Override
    public List<RewardTypeStatisticsVo> findByParticipatorCodeAndRecordCodes(String participatorCode, List<String> recordCodes) {
        if (StringUtils.isBlank((CharSequence)participatorCode) || CollectionUtils.isEmpty(recordCodes) || CollectionUtils.isEmpty(this.rewardTypeStatisticsServiceObserverList)) {
            return null;
        }
        ArrayList list = Lists.newArrayList();
        for (RewardTypeStatisticsServiceObserver rewardServiceObserver : this.rewardTypeStatisticsServiceObserverList) {
            RewardTypeStatisticsVo vo = rewardServiceObserver.onRequestRewardTypeStatisticsVo(participatorCode, recordCodes);
            list.add(vo);
        }
        return list;
    }

    @Override
    public List<RewardTypeStatisticsVo> findByTenantCodeAndTriggerAction(String tenantCode, String triggerAction) {
        if (StringUtils.isBlank((CharSequence)tenantCode) || StringUtils.isBlank((CharSequence)triggerAction) || CollectionUtils.isEmpty(this.rewardTypeStatisticsServiceObserverList)) {
            return null;
        }
        ArrayList list = Lists.newArrayList();
        for (RewardTypeStatisticsServiceObserver rewardServiceObserver : this.rewardTypeStatisticsServiceObserverList) {
            RewardTypeStatisticsVo vo = rewardServiceObserver.onRequestRewardTypeStatisticsVo(tenantCode, triggerAction);
            if (!Objects.nonNull(vo)) continue;
            list.add(vo);
        }
        return list;
    }
}

