/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.admin.web.service.internal;

import com.biz.crm.admin.web.service.ParticipatorReportService;
import com.biz.crm.admin.web.vo.ParticipatorReportVo;
import com.biz.crm.cps.business.agreement.sdk.dto.LoginUserAgreementDto;
import com.biz.crm.cps.business.agreement.sdk.service.AgreementVoService;
import com.biz.crm.cps.business.consumer.sdk.service.ConsumerVoService;
import com.biz.crm.cps.business.consumer.sdk.vo.ConsumerVo;
import com.biz.crm.cps.business.participator.sdk.common.enums.ParticipatorTypeEnum;
import com.biz.crm.cps.business.participator.sdk.service.DealerVoService;
import com.biz.crm.cps.business.participator.sdk.service.TerminalVoService;
import com.biz.crm.cps.business.participator.sdk.vo.DealerVo;
import com.biz.crm.cps.business.participator.sdk.vo.TerminalVo;
import com.biz.crm.cps.business.reward.cost.local.entity.CostDealerEntity;
import com.biz.crm.cps.business.reward.cost.local.entity.CostTerminalEntity;
import com.biz.crm.cps.business.reward.cost.local.service.CostDealerService;
import com.biz.crm.cps.business.reward.cost.local.service.CostTerminalService;
import com.biz.crm.cps.business.reward.integral.local.entity.IntegralEntity;
import com.biz.crm.cps.business.reward.integral.local.service.IntegralService;
import com.biz.crm.cps.business.reward.redpacket.local.entity.RedPacketEntity;
import com.biz.crm.cps.business.reward.redpacket.local.service.RedPacketService;
import com.biz.crm.cps.external.barcode.sdk.dto.ScanCodeRecordStatisticsDto;
import com.biz.crm.cps.external.barcode.sdk.service.ScanCodeRecordVoService;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ParticipatorReportServiceImpl
implements ParticipatorReportService {
    @Autowired
    private RedPacketService redPacketService;
    @Autowired
    private IntegralService integralService;
    @Autowired
    private CostDealerService costDealerService;
    @Autowired
    private CostTerminalService costTerminalService;
    @Autowired
    private ScanCodeRecordVoService scanCodeRecordVoService;
    @Autowired
    private AgreementVoService agreementVoService;
    @Autowired
    private DealerVoService dealerVoService;
    @Autowired
    private TerminalVoService terminalVoService;
    @Autowired
    private ConsumerVoService consumerVoService;

    @Override
    public ParticipatorReportVo findByParticipatorCodeAndType(String participatorCode, String participatorType) {
        List agreemnts;
        IntegralEntity integral;
        RedPacketEntity redPacket;
        ConsumerVo consumerVo;
        List terminals;
        DealerVo dealerVo;
        if (StringUtils.isBlank((CharSequence)participatorCode) || StringUtils.isBlank((CharSequence)participatorType)) {
            return null;
        }
        ParticipatorReportVo vo = new ParticipatorReportVo();
        vo.setCashTotal(BigDecimal.ZERO);
        vo.setCashAvailable(BigDecimal.ZERO);
        vo.setOrderTotal(BigDecimal.ZERO);
        vo.setOrderAmountTotal(BigDecimal.ZERO);
        if (ParticipatorTypeEnum.DEALER.getDictCode().equals(participatorType) && (dealerVo = this.dealerVoService.findByCustomerCode(participatorCode)) != null) {
            vo.setAccessTime(dealerVo.getCreateTime());
        }
        if (ParticipatorTypeEnum.TERMINAL.getDictCode().equals(participatorType) && !CollectionUtils.isEmpty((Collection)(terminals = this.terminalVoService.findByTerminalCodes(Arrays.asList(participatorCode))))) {
            vo.setAccessTime(((TerminalVo)terminals.get(0)).getCreateTime());
        }
        if (ParticipatorTypeEnum.CONSUMER.getDictCode().equals(participatorType) && (consumerVo = this.consumerVoService.findByConsumerCode(participatorCode)) != null) {
            vo.setAccessTime(consumerVo.getCreateTime());
        }
        if ((redPacket = this.redPacketService.findByParticipatorCode(participatorCode)) != null) {
            vo.setRedPacketTotal(redPacket.getAccruingRedPacket() == null ? BigDecimal.ZERO : redPacket.getAccruingRedPacket());
            vo.setRedPacketAvailable(redPacket.getBalance() == null ? BigDecimal.ZERO : redPacket.getBalance());
        } else {
            vo.setRedPacketTotal(BigDecimal.ZERO);
            vo.setRedPacketAvailable(BigDecimal.ZERO);
        }
        if (ParticipatorTypeEnum.DEALER.getDictCode().equals(participatorType)) {
            CostDealerEntity dealer = this.costDealerService.findByDealerCode(participatorCode);
            if (dealer != null) {
                vo.setCostTotal(dealer.getTotalAmount() == null ? BigDecimal.ZERO : dealer.getTotalAmount());
                vo.setCostAvailable(dealer.getUnBilledFee() == null ? BigDecimal.ZERO : dealer.getUnBilledFee());
            } else {
                vo.setCostTotal(BigDecimal.ZERO);
                vo.setCostAvailable(BigDecimal.ZERO);
            }
        }
        if (ParticipatorTypeEnum.TERMINAL.getDictCode().equals(participatorType)) {
            CostTerminalEntity terminal = this.costTerminalService.findByTerminalCode(participatorCode);
            if (terminal != null) {
                vo.setCostTotal(terminal.getTotalAmount() == null ? BigDecimal.ZERO : terminal.getTotalAmount());
                vo.setCostAvailable(terminal.getUnAuditFee() == null ? BigDecimal.ZERO : terminal.getUnAuditFee());
            } else {
                vo.setCostTotal(BigDecimal.ZERO);
                vo.setCostAvailable(BigDecimal.ZERO);
            }
        }
        if ((integral = this.integralService.findByParticipatorCode(participatorCode)) != null) {
            vo.setIntegralTotal(integral.getAccruingIntegral() == null ? BigDecimal.ZERO : integral.getAccruingIntegral());
            vo.setIntegralAvailable(integral.getBalance() == null ? BigDecimal.ZERO : integral.getBalance());
        } else {
            vo.setIntegralTotal(BigDecimal.ZERO);
            vo.setIntegralAvailable(BigDecimal.ZERO);
        }
        LoginUserAgreementDto agreementDto = new LoginUserAgreementDto();
        if (ParticipatorTypeEnum.DEALER.getDictCode().equals(participatorType)) {
            agreementDto.setCustomerCode(participatorCode);
        }
        if (ParticipatorTypeEnum.TERMINAL.getDictCode().equals(participatorType)) {
            agreementDto.setTerminalCode(participatorCode);
        }
        if (!CollectionUtils.isEmpty((Collection)(agreemnts = this.agreementVoService.findByConditions(agreementDto)))) {
            vo.setAgreementTotal(new BigDecimal(agreemnts.size()));
        }
        ScanCodeRecordStatisticsDto dto = new ScanCodeRecordStatisticsDto();
        dto.setScanParticipatorCode(participatorCode);
        Integer integer = this.scanCodeRecordVoService.countByScanCodeRecordDto(dto);
        vo.setScanTotal(integer == null ? BigDecimal.ZERO : new BigDecimal(integer));
        return vo;
    }
}

