/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.admin.web.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.admin.web.dto.QuantifyTaskReportDto;
import com.biz.crm.admin.web.repository.QuantifyPolicyReportRepository;
import com.biz.crm.admin.web.service.QuantifyPolicyReportService;
import com.biz.crm.admin.web.service.RewardRelTriggerObjectVoService;
import com.biz.crm.admin.web.service.RewardTypeStatisticsVoService;
import com.biz.crm.admin.web.vo.QuantifyStatisticsReportVo;
import com.biz.crm.admin.web.vo.QuantifyTaskReportVo;
import com.biz.crm.cps.bisiness.policy.quantify.sdk.constant.QuantifyTaskStatusEnum;
import com.biz.crm.cps.business.participator.sdk.vo.ParticipatorTagVo;
import com.biz.crm.cps.business.policy.quantify.ladder.entity.QuantifyTask;
import com.biz.crm.cps.business.reward.sdk.vo.RewardRelTriggerObjectVo;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class QuantifyPolicyReportServiceImpl
implements QuantifyPolicyReportService {
    @Autowired
    private QuantifyPolicyReportRepository quantifyPolicyReportRepository;
    @Autowired
    private RewardTypeStatisticsVoService rewardTypeStatisticsVoService;
    @Autowired
    private RewardRelTriggerObjectVoService rewardRelTriggerObjectVoService;

    @Override
    public QuantifyStatisticsReportVo findQuantifyStatisticsReportByTenant() {
        QuantifyStatisticsReportVo quantifyStatisticsReportVo = new QuantifyStatisticsReportVo();
        quantifyStatisticsReportVo.setExecutionTaskNumbers(this.quantifyPolicyReportRepository.findQuantifyStatisticsReportByTenant(QuantifyTaskStatusEnum.STATUS_DOING.getCode(), TenantUtils.getTenantCode()));
        quantifyStatisticsReportVo.setFinishTaskNumbers(this.quantifyPolicyReportRepository.findQuantifyStatisticsReportByTenant(QuantifyTaskStatusEnum.STATUS_COMPLETE.getCode(), TenantUtils.getTenantCode()));
        quantifyStatisticsReportVo.setRewardTypeStatisticsVos(this.rewardTypeStatisticsVoService.findByTenantCodeAndTriggerAction(TenantUtils.getTenantCode(), "quantify"));
        return quantifyStatisticsReportVo;
    }

    @Override
    public Page<QuantifyTaskReportVo> findByConditions(Pageable pageable, QuantifyTaskReportDto dto) {
        Page<QuantifyTaskReportVo> page;
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (dto == null) {
            dto = new QuantifyTaskReportDto();
        }
        if (CollectionUtils.isEmpty((Collection)(page = this.quantifyPolicyReportRepository.findByConditions(pageable, dto)).getRecords())) {
            return page;
        }
        List<String> businessCodes = page.getRecords().stream().map(QuantifyTask::getBusinessCode).collect(Collectors.toList());
        List<RewardRelTriggerObjectVo> rewardRelTriggerObjectVos = this.rewardRelTriggerObjectVoService.findByTriggerActionAndTriggerObjects("quantify", businessCodes);
        HashMap map = Maps.newHashMap();
        rewardRelTriggerObjectVos.forEach(vo -> map.put(vo.getTriggerObject(), vo.getRewardTypeStatisticsVos()));
        page.getRecords().forEach(reportVo -> {
            if (StringUtils.isNotBlank((CharSequence)reportVo.getBusinessCode()) && map.containsKey(reportVo.getBusinessCode())) {
                reportVo.setRewardTypeStatisticsVos((List)map.get(reportVo.getBusinessCode()));
            }
            if (!CollectionUtils.isEmpty(reportVo.getParticipatorTagVos())) {
                reportVo.setParticipatorTagStr(reportVo.getParticipatorTagVos().stream().map(ParticipatorTagVo::getTagDescription).collect(Collectors.joining("\uff0c")));
            }
        });
        return page;
    }
}

