/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.admin.web.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.admin.web.dto.ScanCodeRecordConsumerReportDto;
import com.biz.crm.admin.web.dto.ScanCodeRecordDealerReportDto;
import com.biz.crm.admin.web.dto.ScanCodeRecordReportDto;
import com.biz.crm.admin.web.dto.ScanCodeRecordTerminalReportDto;
import com.biz.crm.admin.web.repository.ScanCodeRecordReportRepository;
import com.biz.crm.admin.web.service.ScanCodeRecordReportService;
import com.biz.crm.admin.web.vo.ScanCodeRecordConsumerReportVo;
import com.biz.crm.admin.web.vo.ScanCodeRecordDealerReportVo;
import com.biz.crm.admin.web.vo.ScanCodeRecordReportVo;
import com.biz.crm.admin.web.vo.ScanCodeRecordTerminalReportVo;
import com.biz.crm.cps.business.participator.sdk.common.enums.ParticipatorTypeEnum;
import com.biz.crm.cps.business.policy.quantify.ladder.entity.QuantifyPolicy;
import com.biz.crm.cps.business.policy.quantify.ladder.entity.QuantifyRange;
import com.biz.crm.cps.business.policy.quantify.ladder.entity.QuantifyTask;
import com.biz.crm.cps.business.policy.quantify.ladder.service.QuantifyPolicyService;
import com.biz.crm.cps.business.policy.quantify.ladder.service.QuantifyTaskService;
import com.biz.crm.cps.business.product.sdk.dto.MaterialStandardUnitDto;
import com.biz.crm.cps.business.product.sdk.service.MaterialStandardUnitVoService;
import com.biz.crm.cps.business.product.sdk.service.MaterialVoService;
import com.biz.crm.cps.business.product.sdk.vo.MaterialStandardUnitVo;
import com.biz.crm.cps.business.product.sdk.vo.MaterialVo;
import com.biz.crm.cps.external.barcode.sdk.common.enums.ScanCodeExceptionEnum;
import com.biz.crm.cps.external.barcode.sdk.service.ScanCodeRecordVoService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ScanCodeRecordReportServiceImpl
implements ScanCodeRecordReportService {
    @Resource
    private ScanCodeRecordReportRepository scanCodeRecordReportRepository;
    @Autowired
    private QuantifyTaskService quantifyTaskService;
    @Autowired
    private QuantifyPolicyService quantifyPolicyService;
    @Autowired
    private ScanCodeRecordVoService scanCodeRecordVoService;
    @Autowired
    private MaterialVoService materialVoService;
    @Autowired
    private MaterialStandardUnitVoService materialStandardUnitVoService;

    @Override
    public Page<ScanCodeRecordReportVo> findByConditions(Pageable pageable, ScanCodeRecordReportDto dto) {
        Page<ScanCodeRecordReportVo> page;
        List records;
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (dto == null) {
            dto = new ScanCodeRecordReportDto();
        }
        if (!CollectionUtils.isEmpty((Collection)(records = (page = this.scanCodeRecordReportRepository.findByConditions(pageable, dto)).getRecords()))) {
            this.buildScanCodeList(records);
        }
        return page;
    }

    @Override
    public Page<ScanCodeRecordDealerReportVo> findByDealerConditions(Pageable pageable, ScanCodeRecordDealerReportDto dto) {
        Page<ScanCodeRecordDealerReportVo> page;
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (dto == null) {
            dto = new ScanCodeRecordDealerReportDto();
        }
        if (!CollectionUtils.isEmpty((Collection)(page = this.scanCodeRecordReportRepository.findByDealerConditions(pageable, dto)).getRecords())) {
            for (ScanCodeRecordDealerReportVo vo : page.getRecords()) {
                vo.setScanCodeExceptionDes(ScanCodeExceptionEnum.getDesc((String)vo.getScanCodeException()));
                MaterialVo materialVo = this.materialVoService.findByBarCode(vo.getBarCode());
                if (!Objects.nonNull(materialVo)) continue;
                vo.setMaterialCode(materialVo.getMaterialCode());
                vo.setMaterialName(materialVo.getMaterialName());
            }
        }
        return page;
    }

    @Override
    public Page<ScanCodeRecordTerminalReportVo> findByTerminalConditions(Pageable pageable, ScanCodeRecordTerminalReportDto dto) {
        Page<ScanCodeRecordTerminalReportVo> page;
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (dto == null) {
            dto = new ScanCodeRecordTerminalReportDto();
        }
        if (!CollectionUtils.isEmpty((Collection)(page = this.scanCodeRecordReportRepository.findByTerminalConditions(pageable, dto)).getRecords())) {
            for (ScanCodeRecordTerminalReportVo vo : page.getRecords()) {
                vo.setScanCodeExceptionDes(ScanCodeExceptionEnum.getDesc((String)vo.getScanCodeException()));
                MaterialVo materialVo = this.materialVoService.findByBarCode(vo.getBarCode());
                if (!Objects.nonNull(materialVo)) continue;
                vo.setMaterialCode(materialVo.getMaterialCode());
                vo.setMaterialName(materialVo.getMaterialName());
            }
        }
        return page;
    }

    @Override
    public Page<ScanCodeRecordConsumerReportVo> findByConsumerConditions(Pageable pageable, ScanCodeRecordConsumerReportDto dto) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (dto == null) {
            dto = new ScanCodeRecordConsumerReportDto();
        }
        Page<ScanCodeRecordConsumerReportVo> page = this.scanCodeRecordReportRepository.findByConsumerConditions(pageable, dto);
        return page;
    }

    @Override
    public Page<ScanCodeRecordReportVo> findByQuantifyTaskBusinessCode(Pageable pageable, String quantifyTaskId) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (StringUtils.isBlank((CharSequence)quantifyTaskId)) {
            return null;
        }
        QuantifyTask quantifyTask = this.quantifyTaskService.findById(quantifyTaskId);
        if (!ObjectUtils.allNotNull((Object[])new Object[]{quantifyTask})) {
            return null;
        }
        QuantifyPolicy quantifyPolicy = this.quantifyPolicyService.findDetailByTemplateCode(quantifyTask.getTemplateId());
        if (!ObjectUtils.allNotNull((Object[])new Object[]{quantifyTask})) {
            return null;
        }
        ArrayList dimensionCodes = Lists.newArrayList();
        if (!quantifyPolicy.getDimensionFlag().equals("DIMENSION_ALL")) {
            quantifyPolicy.getQuantifyConfigurations().forEach(configuration -> {
                List dimensions = configuration.getQuantifyRanges().stream().map(QuantifyRange::getSpecialCode).collect(Collectors.toList());
                List materialCodes = this.materialVoService.findMaterialCodeByDimensionCodesAndDimensionType(dimensions, quantifyPolicy.getDimensionFlag());
                if (!CollectionUtils.isEmpty((Collection)materialCodes)) {
                    dimensionCodes.addAll(materialCodes);
                }
            });
        }
        if (CollectionUtils.isEmpty((Collection)dimensionCodes)) {
            return null;
        }
        ScanCodeRecordReportDto scanCodeRecordReportDto = new ScanCodeRecordReportDto();
        scanCodeRecordReportDto.setParticipatorType(ParticipatorTypeEnum.TERMINAL.getKey());
        scanCodeRecordReportDto.setScanParticipatorCode(quantifyTask.getTerminalCode());
        scanCodeRecordReportDto.setCreateTimeStart(quantifyTask.getTaskStartTime());
        scanCodeRecordReportDto.setCreateTimeEnd(quantifyTask.getTaskEndTime());
        scanCodeRecordReportDto.setProductCodes(dimensionCodes);
        Page<ScanCodeRecordReportVo> page = this.scanCodeRecordReportRepository.findByConditions(pageable, scanCodeRecordReportDto);
        if (CollectionUtils.isEmpty((Collection)page.getRecords())) {
            return page;
        }
        this.buildScanCodeList(page.getRecords());
        ArrayList materialStandardUnitDtos = Lists.newArrayList();
        page.getRecords().forEach(scanCodeRecordVo -> {
            MaterialStandardUnitDto materialStandardUnitDto = new MaterialStandardUnitDto();
            materialStandardUnitDto.setMaterialCode(scanCodeRecordVo.getProductCode());
            materialStandardUnitDtos.add(materialStandardUnitDto);
        });
        List unitVos = this.materialStandardUnitVoService.findByMaterialCodeAndBarCodeType((List)materialStandardUnitDtos);
        if (CollectionUtils.isEmpty((Collection)unitVos)) {
            return page;
        }
        Map unitVoMap = unitVos.stream().collect(Collectors.toMap(MaterialStandardUnitVo::getMaterialCode, Function.identity()));
        page.getRecords().forEach(scanCodeRecordVo -> {
            MaterialStandardUnitVo unitVo = (MaterialStandardUnitVo)unitVoMap.get(scanCodeRecordVo.getProductCode());
            if (ObjectUtils.allNotNull((Object[])new Object[]{unitVo})) {
                scanCodeRecordVo.setProductName(unitVo.getMaterialName());
                scanCodeRecordVo.setStandardUnit(unitVo.getStandardUnit());
                scanCodeRecordVo.setStandardUnitDesc(unitVo.getStandardUnitDesc());
            }
        });
        return page;
    }

    private void buildScanCodeList(List<ScanCodeRecordReportVo> records) {
        records.stream().forEach(scanCodeRecordReportVo -> {
            if (ParticipatorTypeEnum.DEALER.getKey().equals(scanCodeRecordReportVo.getParticipatorType())) {
                scanCodeRecordReportVo.setChannelName(scanCodeRecordReportVo.getDealerChannelName());
                scanCodeRecordReportVo.setOrgName(scanCodeRecordReportVo.getDealerOrgName());
                scanCodeRecordReportVo.setCustomerCode(scanCodeRecordReportVo.getDealerCode());
                scanCodeRecordReportVo.setCustomerName(scanCodeRecordReportVo.getDealerName());
            }
            if (ParticipatorTypeEnum.TERMINAL.getKey().equals(scanCodeRecordReportVo.getParticipatorType())) {
                scanCodeRecordReportVo.setChannelName(scanCodeRecordReportVo.getTerminalChannelName());
                scanCodeRecordReportVo.setOrgName(scanCodeRecordReportVo.getTerminalOrgName());
                scanCodeRecordReportVo.setCustomerCode(scanCodeRecordReportVo.getTerminalCode());
                scanCodeRecordReportVo.setCustomerName(scanCodeRecordReportVo.getTerminalName());
            }
            if (ParticipatorTypeEnum.CONSUMER.getKey().equals(scanCodeRecordReportVo.getParticipatorType())) {
                scanCodeRecordReportVo.setCustomerCode(scanCodeRecordReportVo.getConsumerExternalId());
                scanCodeRecordReportVo.setCustomerName(scanCodeRecordReportVo.getConsumerNickname());
            }
        });
    }
}

