/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.admin.web.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.admin.web.dto.ScanCodeAgreementReportDto;
import com.biz.crm.admin.web.service.RewardRelScanCodeVoService;
import com.biz.crm.admin.web.service.ScanCodeAgreementReportVoService;
import com.biz.crm.admin.web.vo.ScanCodeAgreementReportVo;
import com.biz.crm.cps.business.agreement.local.entity.Agreement;
import com.biz.crm.cps.business.agreement.local.service.AgreementService;
import com.biz.crm.cps.business.agreement.sdk.dto.AgreementDto;
import com.biz.crm.cps.business.participator.sdk.common.enums.ParticipatorTypeEnum;
import com.biz.crm.cps.business.reward.sdk.vo.RewardRelScanCodeVo;
import com.bizunited.platform.common.service.NebulaToolkitService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ScanCodeAgreementReportVoServiceImpl
implements ScanCodeAgreementReportVoService {
    @Autowired
    private AgreementService agreementService;
    @Autowired
    private RewardRelScanCodeVoService rewardRelScanCodeVoService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    @Override
    public Page<ScanCodeAgreementReportVo> findByConditions(Pageable pageable, ScanCodeAgreementReportDto dto) {
        List<String> codes;
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (dto == null) {
            dto = new ScanCodeAgreementReportDto();
        }
        if (CollectionUtils.isEmpty(codes = this.findTemplateCodesByScanCodeAgreementReportDto(dto))) {
            return null;
        }
        AgreementDto agreementDto = new AgreementDto();
        String participatorType = dto.getParticipatorType();
        String scanParticipatorCode = dto.getScanParticipatorCode();
        if (ParticipatorTypeEnum.DEALER.getKey().equals(participatorType)) {
            agreementDto.setCustomerCode(scanParticipatorCode);
        } else if (ParticipatorTypeEnum.TERMINAL.getKey().equals(participatorType)) {
            agreementDto.setTerminalCode(scanParticipatorCode);
        }
        agreementDto.setTemplateCodes(codes);
        Page conditions = this.agreementService.findByConditions(pageable, agreementDto);
        if (Objects.isNull(conditions)) {
            return null;
        }
        List records = conditions.getRecords();
        if (!CollectionUtils.isEmpty((Collection)records)) {
            List scanCodeAgreementReportVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)records, Agreement.class, ScanCodeAgreementReportVo.class, HashSet.class, ArrayList.class, new String[0]);
            Page voPage = new Page();
            voPage.setRecords(scanCodeAgreementReportVos);
            voPage.setCurrent(conditions.getCurrent());
            voPage.setSize(conditions.getSize());
            voPage.setTotal(conditions.getTotal());
            return voPage;
        }
        return null;
    }

    private List<String> findTemplateCodesByScanCodeAgreementReportDto(ScanCodeAgreementReportDto dto) {
        if (Objects.isNull(dto)) {
            return null;
        }
        String dictCode = ParticipatorTypeEnum.getByKey((String)dto.getParticipatorType()).getDictCode();
        ArrayList<String> list = new ArrayList<String>();
        list.add(dto.getRecordCode());
        List<RewardRelScanCodeVo> participatorCodeAndRecordCodes = this.rewardRelScanCodeVoService.findByParticipatorCodeAndRecordCodes(dto.getScanParticipatorCode(), dictCode, list);
        if (CollectionUtils.isEmpty(participatorCodeAndRecordCodes)) {
            return null;
        }
        List rewardRelScanCodeItemVos = participatorCodeAndRecordCodes.get(0).getRewardRelScanCodeItemVos();
        ArrayList<String> arrayList = new ArrayList<String>();
        rewardRelScanCodeItemVos.stream().forEach(rewardRelScanCodeItemVo -> {
            List templateCodes = rewardRelScanCodeItemVo.getTemplateCodes();
            arrayList.addAll(templateCodes);
        });
        return arrayList;
    }
}

