package com.biz.crm.admin.web.controller;

import com.biz.crm.admin.web.service.AgreementReportVoService;
import com.biz.crm.admin.web.vo.AgreementReportVo;
import com.biz.crm.cps.business.common.local.model.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 协议分利信息报表
 * @author songjingen
 */
@Slf4j
@RestController
@RequestMapping("/v1/web/agreementReport")
@Api(tags = "协议分利信息报表")
public class AgreementReportVoController {

  @Autowired
  private AgreementReportVoService agreementReportVoService;

  /**
   * 根据编码和类型查询
   * @param code
   * @param type
   * @return
   */
  @ApiOperation(value = "根据编码和类型查询")
  @GetMapping("/findAgreementAndType")
  public Result<AgreementReportVo> findAgreementAndType(@ApiParam(name = "code", value = "协议编码") String code,
                                                        @ApiParam(name = "type", value = "类型") String type) {
    try {
      AgreementReportVo vo =  agreementReportVoService.findAgreementAndType(code, type);
      return Result.ok(vo);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 根据编码查询分利信息
   * @param code
   * @return
   */
  @ApiOperation(value = "根据编码查询分利信息")
  @GetMapping("/findByAgreementCode")
  public Result<AgreementReportVo> findByAgreementCode(@ApiParam(name = "code", value = "协议编码") String code) {
    try {
      AgreementReportVo vo =  agreementReportVoService.findByAgreementCode(code);
      return Result.ok(vo);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
