package com.biz.crm.admin.web.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.admin.web.dto.AgreementRewardDto;
import com.biz.crm.admin.web.service.AgreementRewardVoService;
import com.biz.crm.admin.web.vo.AgreementRewardVo;
import com.biz.crm.cps.business.common.local.model.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 协议分利明细报表
 * @Author: zengxingwang
 * @Date: 2021/9/23 14:35
 */
@Slf4j
@RestController
@RequestMapping("/v1/web/agreementReward")
@Api(tags = "协议分利明细报表")
public class AgreementRewardVoController {

  @Autowired
  private AgreementRewardVoService agreementRewardVoService;
  /**
   * 多条件分页查询
   *
   * @return
   */
  @ApiOperation(value = "多条件分页查询")
  @GetMapping("findByConditions")
  public Result<Page<AgreementRewardVo>> findByConditions(@PageableDefault(50) Pageable pageable,
                                                          @ApiParam(name = "agreementRewardDto") AgreementRewardDto agreementRewardDto) {
    try {
      Page<AgreementRewardVo> result = this.agreementRewardVoService.findByConditions(pageable, agreementRewardDto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
