package com.biz.crm.admin.web.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.admin.web.dto.ConsumerReportDto;
import com.biz.crm.admin.web.service.ConsumerReportService;
import com.biz.crm.admin.web.vo.ConsumerReportVo;
import com.biz.crm.cps.business.common.local.model.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 消费者报表相关http接口
 * @author songjingen
 */
@Api(tags = "消费者报表")
@Slf4j
@RestController
@RequestMapping("/v1/web/consumerReport")
public class ConsumerReportController {

  @Autowired
  private ConsumerReportService consumerReportService;

  /**
   * 只是（分页）查询分利消费者的基本信息
   * 查询消费者数据时，无要求
   * 查询黑名单数据时，需要赋值consumer.blacklistStatus = "009"
   * @param dto
   * @return
   */
  @ApiOperation(value = "只是（分页）查询分利消费者的基本信息, 查询消费者数据时，无要求；查询黑名单数据时，需要赋值consumer.blacklistStatus = '009'")
  @GetMapping(value = "/findByConditions")
  public Result<Page<ConsumerReportVo>> findByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                         @ApiParam(name = "consumer", value = "分利消费者对象") ConsumerReportDto dto) {
    try {
      Page<ConsumerReportVo> listByPage = consumerReportService.findByConditions(pageable, dto);
      return Result.ok(listByPage);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 消费者分利信息
   * @param consumerCode 消费者编码
   * @return
   */
  @ApiOperation(value = "消费者分利信息")
  @GetMapping(value = "/findDetailsByConsumerCode")
  public Result<ConsumerReportVo> findDetailsByConsumerCode(@ApiParam(name = "consumerCode", value = "消费者编码") String consumerCode) {
    try {
      return Result.ok(consumerReportService.findDetailsByConsumerCode(consumerCode));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
