package com.biz.crm.admin.web.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.admin.web.dto.ConsumerTerminalMappingDto;
import com.biz.crm.admin.web.service.ConsumerTerminalMappingReportService;
import com.biz.crm.admin.web.vo.ConsumerTerminalMappingReportVo;
import com.biz.crm.cps.business.common.local.model.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/**
 * 消费者关联终端报表相关http接口
 * @author songjingen
 */
@Api(tags = "消费者报表")
@Slf4j
@RestController
@RequestMapping("/v1/web/consumerTerminalMappingReport")
public class ConsumerTerminalMappingReportController {

  @Resource
  private ConsumerTerminalMappingReportService consumerTerminalMappingReportService;

  /**
   * 消费者关联终端报表分页查询
   * @param dto
   * @return
   */
  @ApiOperation(value = "消费者关联终端报表分页查询")
  @GetMapping(value = "/findByConditions")
  public Result<Page<ConsumerTerminalMappingReportVo>> findByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                                        @ApiParam(name = "dto", value = "消费者关联终端报表查询dto") ConsumerTerminalMappingDto dto) {
    try {
      Page<ConsumerTerminalMappingReportVo> page = consumerTerminalMappingReportService.findByConditions(pageable, dto);
      return Result.ok(page);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
