package com.biz.crm.admin.web.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.admin.web.dto.ContractSignReportDto;
import com.biz.crm.admin.web.service.ContractSignReportVoService;
import com.biz.crm.admin.web.vo.ContractSignReportVo;
import com.biz.crm.cps.business.common.local.model.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 法大大合同签署报表
 * @author songjingen
 */
@Slf4j
@RestController
@RequestMapping("/v1/web/contractSign")
@Api(tags = "法大大合同签署报表")
public class ContractSignReportVoController {

  @Autowired
  private ContractSignReportVoService contractSignReportVoService;

  /**
   * 根据查询条件分页查询列表
   * @param dto
   * @return
   */
  @ApiOperation(value = "根据查询条件分页查询列表")
  @GetMapping(value = "/findByConditions")
  public Result<Page<ContractSignReportVo>> findByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                             @ApiParam(name = "dto", value = "合同签署报表Dto") ContractSignReportDto dto) {
    try {
      Page<ContractSignReportVo> page = contractSignReportVoService.findByConditions(pageable, dto);
      return Result.ok(page);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

}
