package com.biz.crm.admin.web.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.admin.web.dto.CostDetailReportPaginationDto;
import com.biz.crm.admin.web.service.CostDetailReportVoService;
import com.biz.crm.admin.web.vo.CostDetailReportVo;
import com.biz.crm.cps.business.common.local.model.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 费用明细报表控制器
 * @Author dy
 * @DATE 2022/4/24
 **/
@RestController
@Slf4j
@Api(tags = "费用明细报表类:CostDetailReportVo: 费用明细报表类")
@RequestMapping("/v1/web/costDetailReport")
public class CostDetailReportController {

  @Autowired
  private CostDetailReportVoService costDetailReportVoService;

  /**
   * 费用流水明细列表 --经销商
   *
   * @param pageable
   * @param dto
   * @return
   */
  @ApiOperation("费用流水明细列表 --经销商")
  @GetMapping("/findDealerByConditions")
  public Result<Page<CostDetailReportVo>> findDealerByConditions(
      @PageableDefault(50) Pageable pageable, CostDetailReportPaginationDto dto) {
    try {
      Page<CostDetailReportVo> page =
          this.costDetailReportVoService.findDealerByConditions(pageable, dto);
      return Result.ok(page);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
