package com.biz.crm.admin.web.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.admin.web.service.DealerReportService;
import com.biz.crm.cps.business.common.local.model.Result;
import com.biz.crm.cps.business.participator.sdk.dto.DealerDto;
import com.biz.crm.cps.business.participator.sdk.vo.DealerVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 分利经销商报表controller
 * @author zengxingwang
 */
@Api(tags = "分利经销商报表controller")
@Slf4j
@RestController
@RequestMapping("/v1/web/dealerReport")
public class DealerReportController {

  @Autowired
  private DealerReportService dealerReportService;

  /**
   * 条件查询分利经销商列表
   */
  @ApiOperation(value = "条件查询分利经销商列表")
  @GetMapping(value="findByConditions")
  public Result<Page<DealerVo>> findByConditions(@ApiParam(name="dealerDto" , value="经销商列表vo") DealerDto dealerDto,
                                                 @PageableDefault(50) Pageable pageable) {
    try {
      Page<DealerVo> vos = dealerReportService.findByConditions(dealerDto, pageable);
      return Result.ok(vos);
    } catch(RuntimeException e) {
      log.error(e.getMessage() , e);
      return Result.error(e.getMessage());
    }
  }
}
