package com.biz.crm.admin.web.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.admin.web.dto.DisplayCalculateTaskReportDto;
import com.biz.crm.admin.web.dto.DisplayTaskReportDto;
import com.biz.crm.admin.web.dto.TaskScanCodeItemStatisticsDto;
import com.biz.crm.admin.web.service.DisplayPolicyReportService;
import com.biz.crm.admin.web.vo.DisplayCalculateTaskReportVo;
import com.biz.crm.admin.web.vo.DisplayStatisticsReportVo;
import com.biz.crm.admin.web.vo.DisplayTaskReportVo;
import com.biz.crm.admin.web.vo.ShareProfitStatisticsVo;
import com.biz.crm.admin.web.vo.TaskScanCodeItemStatisticsVo;
import com.biz.crm.admin.web.vo.TaskScanCodeStatisticsVo;
import com.biz.crm.cps.business.common.local.model.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 陈列政策相关报表
 *
 * @author HuaHongQiang
 */
@Api(tags = "陈列政策报表（后台）")
@Slf4j
@RestController
@RequestMapping("/v1/web/displayPolicyReport")
public class DisplayPolicyReportController {

  @Autowired(required = false)
  private DisplayPolicyReportService displayPolicyReportService;

  /**
   * 获取陈列任务统计信息
   *
   * @return 统计信息
   */
  @ApiOperation(value = "获取陈列任务统计信息")
  @GetMapping(value = "/findDisplayStatisticsReportByTenant")
  public Result<DisplayStatisticsReportVo> findDisplayStatisticsReportByTenant() {
    try {
      return Result.ok(displayPolicyReportService.findDisplayStatisticsReportByTenant());
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 分页获取陈列任务明细信息列表
   *
   * @param pageable
   * @param dto
   * @return
   */
  @ApiOperation(value = "分页获取陈列任务明细信息列表")
  @GetMapping(value = "/findByConditions")
  public Result<Page<DisplayTaskReportVo>> findByConditions(
      @ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
      @ApiParam(name = "dto", value = "分利协议信息分页条件查询dto") DisplayTaskReportDto dto) {
    try {
      Page<DisplayTaskReportVo> page = displayPolicyReportService.findByConditions(pageable, dto);
      return Result.ok(page);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 陈列政策分利任务报表列表
   *
   * @param pageable
   * @param dto
   * @return
   */
  @ApiOperation(value = "陈列政策分利任务报表列表")
  @GetMapping(value = "/findByDisplayCalculateTaskReportDto")
  public Result<Page<DisplayCalculateTaskReportVo>> findByDisplayCalculateTaskReportDto(
      @ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
      @ApiParam(name = "dto", value = "dto") DisplayCalculateTaskReportDto dto) {
    try {
      Page<DisplayCalculateTaskReportVo> page =
          this.displayPolicyReportService.findByDisplayCalculateTaskReportDto(pageable, dto);
      return Result.ok(page);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 陈列政策分利任务扫码统计信息
   *
   * @param businessCode
   * @return
   */
  @ApiOperation(value = "陈列政策分利任务扫码统计信息")
  @GetMapping(value = "/findTaskScanCodeStatisticsVo")
  public Result<TaskScanCodeStatisticsVo> findTaskScanCodeStatisticsVo(
      @RequestParam("businessCode") String businessCode) {
    try {
      return Result.ok(this.displayPolicyReportService.findTaskScanCodeStatisticsVo(businessCode));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 陈列政策分利任务扫码情况
   *
   * @param pageable
   * @param dto
   * @return
   */
  @ApiOperation(value = "陈列政策分利任务扫码情况")
  @GetMapping(value = "/findTaskScanCodeItemStatisticsVo")
  public Result<Page<TaskScanCodeItemStatisticsVo>> findTaskScanCodeItemStatisticsVo(
      @PageableDefault(50) Pageable pageable, TaskScanCodeItemStatisticsDto dto) {
    try {
      Page<TaskScanCodeItemStatisticsVo> page =
          this.displayPolicyReportService.findTaskScanCodeItemStatisticsVo(pageable, dto);
      return Result.ok(page);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 陈列政策分利任务分利情况
   *
   * @param pageable
   * @param businessCode
   * @return
   */
  @ApiOperation(value = "陈列政策分利任务分利情况")
  @GetMapping(value = "/findShareProfitStatisticsVo")
  public Result<Page<ShareProfitStatisticsVo>> findShareProfitStatisticsVo(
      @PageableDefault(50) Pageable pageable, @RequestParam("businessCode") String businessCode) {
    try {
      Page<ShareProfitStatisticsVo> page =
          this.displayPolicyReportService.findShareProfitStatisticsVo(pageable, businessCode);
      return Result.ok(page);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
