package com.biz.crm.admin.web.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.admin.web.dto.IntegralReportPaginationDto;
import com.biz.crm.admin.web.service.IntegralReportService;
import com.biz.crm.admin.web.vo.IntegralReportVo;
import com.biz.crm.cps.business.common.local.model.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 积分明细报表类 controller
 *
 * @author sunx
 * @date 2022/3/24
 */
@RestController
@Slf4j
@Api(tags = "积分明细报表类: : 积分明细报表类")
@RequestMapping("/v1/web/integralReport")
public class IntegralReportController {

  @Autowired IntegralReportService integralReportService;

  /**
   * 积分流水明细列表
   *
   * @param pageable
   * @param dto
   * @return
   */
  @ApiOperation("积分流水明细列表")
  @GetMapping("/findByConditions")
  public Result<Page<IntegralReportVo>> findByConditions(
      @PageableDefault(50) Pageable pageable, IntegralReportPaginationDto dto) {
    try {
      Page<IntegralReportVo> page =
          this.integralReportService.findByConditions(pageable, dto);
      return Result.ok(page);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
