package com.biz.crm.admin.web.controller;

import com.biz.crm.admin.web.service.ParticipatorReportService;
import com.biz.crm.admin.web.vo.ParticipatorReportVo;
import com.biz.crm.cps.business.common.local.model.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 参与者分利报表
 * @Author: zengxingwang
 * @Date: 2021/9/17 14:09
 */
@Api(tags = "参与者分利报表")
@Slf4j
@RestController
@RequestMapping("/v1/web/participatorReport")
public class ParticipatorReportController {

  @Autowired
  private ParticipatorReportService participatorReportService;

  /**
   * 分利参与者分利报表
   * @param participatorCode
   * @param participatorType
   * @return
   */
  @ApiOperation(value = "分利参与者分利报表")
  @GetMapping("findByParticipatorCodeAndType")
  public Result<ParticipatorReportVo> findByParticipatorCodeAndType(@ApiParam(name = "participatorCode", value = "分利参与者编码") String participatorCode,
                                                                    @ApiParam(name = "participatorType", value = "分利参与者类型") String participatorType) {
    try {
      ParticipatorReportVo result = this.participatorReportService.findByParticipatorCodeAndType(participatorCode, participatorType);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
