package com.biz.crm.admin.web.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.admin.web.dto.ParticipatorRewardDto;
import com.biz.crm.admin.web.service.ParticipatorRewardVoService;
import com.biz.crm.admin.web.vo.ParticipatorRewardVo;
import com.biz.crm.cps.business.common.local.model.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 参与者协议分利明细报表
 * @Author: zengxingwang
 * @Date: 2021/9/23 14:35
 */
@Slf4j
@RestController
@RequestMapping("/v1/web/participatorReward")
@Api(tags = "参与者协议分利明细报表")
public class ParticipatorRewardVoController {

  @Autowired
  private ParticipatorRewardVoService participatorRewardVoService;
  /**
   * 多条件分页查询
   *
   * @return
   */
  @ApiOperation(value = "多条件分页查询")
  @GetMapping("findByConditions")
  public Result<Page<ParticipatorRewardVo>> findByConditions(@PageableDefault(50) Pageable pageable,
                                                             @ApiParam(name = "dto") ParticipatorRewardDto dto) {
    try {
      Page<ParticipatorRewardVo> result = this.participatorRewardVoService.findByConditions(pageable, dto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
