package com.biz.crm.admin.web.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.admin.web.dto.QuantifyTaskReportDto;
import com.biz.crm.admin.web.service.QuantifyPolicyReportService;
import com.biz.crm.admin.web.vo.QuantifyStatisticsReportVo;
import com.biz.crm.admin.web.vo.QuantifyTaskReportVo;
import com.biz.crm.cps.business.common.local.model.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.*;

/**
 * 包量政策相关报表
 *
 * @author jerry7
 */
@Api(tags = "包量政策报表（后台）")
@Slf4j
@RestController
@RequestMapping("/v1/web/quantifyPolicyReport")
public class QuantifyPolicyReportController {

  @Autowired(required = false)
  private QuantifyPolicyReportService quantifyPolicyReportService;

  /**
   * 获取包量任务统计信息
   *
   * @return 统计信息
   */
  @ApiOperation(value = "获取包量任务统计信息")
  @GetMapping(value = "/findQuantifyStatisticsReportByTenant")
  public Result<QuantifyStatisticsReportVo> findQuantifyStatisticsReportByTenant() {
    try {
      return Result.ok(quantifyPolicyReportService.findQuantifyStatisticsReportByTenant());
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "分页获取包量任务信息列表")
  @GetMapping(value = "/findByConditions")
  public Result<Page<QuantifyTaskReportVo>> findByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                             @ApiParam(name = "dto", required = false, value = "分利协议信息分页条件查询dto") QuantifyTaskReportDto dto) {
    try {
      Page<QuantifyTaskReportVo> page = quantifyPolicyReportService.findByConditions(pageable,dto);
      return Result.ok(page);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
}

}
