package com.biz.crm.admin.web.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.admin.web.service.QuantifyStatisticsVoTaskService;
import com.biz.crm.admin.web.vo.QuantifyStatisticsVo;
import com.biz.crm.cps.business.common.local.model.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/** 包量任务统计 @Author: zengxingwang @Date: 2021/11/23 16:34 */
@Api(tags = "包量任务统计")
@Slf4j
@RestController
@RequestMapping("/v1/web/quantifyStatisticsTask")
public class QuantifyStatisticsVoTaskController {

  @Autowired private QuantifyStatisticsVoTaskService quantifyStatisticsTaskService;

  /**
   * 销量明细
   *
   * @param businessCode
   * @param pageable
   * @return
   */
  @ApiOperation(value = "销量明细")
  @GetMapping(value = "/findByBusinessCode")
  public Result<Page<QuantifyStatisticsVo>> findByBusinessCode(
      @ApiParam(name = "businessCode", value = "业务编码") @RequestParam("businessCode")
          String businessCode,
      @PageableDefault(50) Pageable pageable) {
    try {
      Page<QuantifyStatisticsVo> page =
          quantifyStatisticsTaskService.findByBusinessCodeForForMaterial(businessCode, pageable);
      return Result.ok(page);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /** 返利明细 */
  @ApiOperation(value = "返利明细")
  @GetMapping(value = "/findByBusinessCodeAndTriggerAction")
  public Result<Page<QuantifyStatisticsVo>> findByBusinessCodeAndTriggerAction(
      @ApiParam(name = "businessCode", value = "业务编码") @RequestParam("businessCode")
          String businessCode,
      @PageableDefault(50) Pageable pageable) {
    try {
      Page<QuantifyStatisticsVo> page =
          quantifyStatisticsTaskService.findByBusinessCodeAndTriggerAction(businessCode, pageable);
      return Result.ok(page);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
