package com.biz.crm.admin.web.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.admin.web.dto.RedPacketReportPaginationDto;
import com.biz.crm.admin.web.service.RedPacketReportService;
import com.biz.crm.admin.web.vo.RedPacketReportVo;
import com.biz.crm.cps.business.common.local.model.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 红包明细报表类 controller
 *
 * @author sunx
 * @date 2022/3/24
 */
@RestController
@Slf4j
@Api(tags = "红包明细报表类: : 红包明细报表类")
@RequestMapping("/v1/web/redPacketReport")
public class RedPacketReportController {

  @Autowired RedPacketReportService redPacketReportService;

  /**
   * 红包流水明细列表
   *
   * @param pageable
   * @param dto
   * @return
   */
  @ApiOperation("红包流水明细列表")
  @GetMapping("/findByConditions")
  public Result<Page<RedPacketReportVo>> findByConditions(
      @PageableDefault(50) Pageable pageable, RedPacketReportPaginationDto dto) {
    try {
      Page<RedPacketReportVo> page =
          this.redPacketReportService.findByConditions(pageable, dto);
      return Result.ok(page);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 红包流水明细列表 --终端
   *
   * @param pageable
   * @param dto
   * @return
   */
  @ApiOperation("红包流水明细列表 --终端")
  @GetMapping("/findTerminalByConditions")
  public Result<Page<RedPacketReportVo>> findTerminalByConditions(
      @PageableDefault(50) Pageable pageable, RedPacketReportPaginationDto dto) {
    try {
      Page<RedPacketReportVo> page =
          this.redPacketReportService.findTerminalByConditions(pageable, dto);
      return Result.ok(page);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 红包流水明细列表 --经销商
   *
   * @param pageable
   * @param dto
   * @return
   */
  @ApiOperation("红包流水明细列表 --经销商")
  @GetMapping("/findDealerByConditions")
  public Result<Page<RedPacketReportVo>> findDealerByConditions(
      @PageableDefault(50) Pageable pageable, RedPacketReportPaginationDto dto) {
    try {
      Page<RedPacketReportVo> page =
          this.redPacketReportService.findDealerByConditions(pageable, dto);
      return Result.ok(page);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
