package com.biz.crm.admin.web.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.admin.web.service.RewardActivityReceiveVoService;
import com.biz.crm.cps.business.activity.actual.sdk.dto.RewardActivityReceiveDto;
import com.biz.crm.cps.business.activity.actual.sdk.vo.RewardActivityReceiveVo;
import com.biz.crm.cps.business.common.local.model.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @Author: zengxingwang
 * @Date: 2021/10/20 14:52
 */
@Api(tags = "活动奖励中奖")
@Slf4j
@RestController
@RequestMapping("/v1/activity/rewardActivityReceive")
public class RewardActivityReceiveVoController {

  @Autowired
  private RewardActivityReceiveVoService rewardActivityReceiveVoService;
  /**
   * 条件查询中奖列表
   */
  @ApiOperation(value = "条件查询中奖列表")
  @GetMapping(value="findByConditions")
  public Result<Page<RewardActivityReceiveVo>> findByConditions(@ApiParam(name="dto" , value="条件查询中奖列表dto") RewardActivityReceiveDto dto,
                                                                @PageableDefault(50) Pageable pageable) {
    try {
      Page<RewardActivityReceiveVo> page = rewardActivityReceiveVoService.findByConditions(dto, pageable);
      return Result.ok(page);
    } catch(RuntimeException e) {
      log.error(e.getMessage() , e);
      return Result.error(e.getMessage());
    }
  }
}
