package com.biz.crm.admin.web.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.admin.web.dto.RewardGiftDetailReportDto;
import com.biz.crm.admin.web.service.RewardGiftDetailReportService;
import com.biz.crm.admin.web.vo.RewardGiftDetailReportVo;
import com.biz.crm.cps.business.common.local.model.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 奖励赠品流水明细报表
 * @author songjingen
 */
@RestController
@RequestMapping("/v1/web/rewardGiftDetailReport")
@Slf4j
@Api(tags = "奖励赠品流水明细报表")
public class RewardGiftDetailReportController {

  @Autowired
  private RewardGiftDetailReportService rewardGiftDetailReportService;

  /**
   * 奖励赠品流水明细报表分页查询
   * @return
   */
  @GetMapping("/findByConditions")
  @ApiOperation("奖励赠品流水明细报表分页查询")
  public Result<Page<RewardGiftDetailReportVo>> findByConditions(@ApiParam(name = "dto", value = "奖励赠品明细信息报表dto") RewardGiftDetailReportDto dto, @PageableDefault(50) Pageable pageable) {
    try {
      return Result.ok(this.rewardGiftDetailReportService.findByConditions(pageable, dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

}
