package com.biz.crm.admin.web.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.admin.web.dto.ScanCodeAgreementReportDto;
import com.biz.crm.admin.web.service.ScanCodeAgreementReportVoService;
import com.biz.crm.admin.web.vo.ScanCodeAgreementReportVo;
import com.biz.crm.cps.business.common.local.model.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 扫码协议报表信息
 * @author songjingen
 */
@RestController
@RequestMapping("/v1/web/scanCodeAgreementReport")
@Slf4j
@Api(tags = "扫码协议报表信息")
public class ScanCodeAgreementReportVoController {

  @Autowired
  private ScanCodeAgreementReportVoService scanCodeAgreementReportVoService;


  /**
   * 扫码记录关联协议信息分页条件查询
   * @param
   * @return
   */
  @ApiOperation(value = "扫码记录关联协议信息分页条件查询")
  @GetMapping("/findByConditions")
  public Result<Page<ScanCodeAgreementReportVo>> findByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                                  @ApiParam(name = "dto", value = "扫码协议dto") ScanCodeAgreementReportDto dto) {
    try {
      Page<ScanCodeAgreementReportVo> page =  scanCodeAgreementReportVoService.findByConditions(pageable, dto);
      return Result.ok(page);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }


}
