package com.biz.crm.admin.web.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.admin.web.dto.ScanCodeRecordReportPaginationDto;
import com.biz.crm.admin.web.service.ScanCodeRecordReportAllVoService;
import com.biz.crm.admin.web.vo.ScanCodeRecordReportAllVo;
import com.biz.crm.cps.business.common.local.model.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 扫码记录报表
 *
 * @author sunx
 * @date 2022/3/29
 */
@Api(tags = "扫码记录报表: ScanCodeRecordReportAllVo: 扫码记录报表")
@Slf4j
@RestController
@RequestMapping("/v1/web/scanCodeRecordReport")
public class ScanCodeRecordReportAllVoController {

  @Autowired private ScanCodeRecordReportAllVoService scanCodeRecordReportAllVoService;

  /**
   * 通过查询条件查询当前参与者的扫码记录分页信息(导购)
   *
   * @param dto
   * @return
   */
  @ApiOperation(value = "通过查询条件查询当前参与者的扫码记录分页信息(导购)")
  @GetMapping(value = "/findUserGuideByConditions")
  public Result<Page<ScanCodeRecordReportAllVo>> findUserGuideByConditions(
      @ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
      @ApiParam(name = "dto", value = "扫码记录报表查询dto") ScanCodeRecordReportPaginationDto dto) {
    try {
      Page<ScanCodeRecordReportAllVo> page =
          scanCodeRecordReportAllVoService.findUserGuideByConditions(pageable, dto);
      return Result.ok(page);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 通过查询条件查询扫码记录分页信息(终端)
   *
   * @param dto
   * @return
   */
  @ApiOperation(value = "通过查询条件查询当前参与者的扫码记录分页信息(终端)")
  @GetMapping(value = "/findTerminalByConditions")
  public Result<Page<ScanCodeRecordReportAllVo>> findTerminalByConditions(
      @ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
      @ApiParam(name = "dto", value = "扫码记录报表查询dto") ScanCodeRecordReportPaginationDto dto) {
    try {
      Page<ScanCodeRecordReportAllVo> page =
          scanCodeRecordReportAllVoService.findTerminalByConditions(pageable, dto);
      return Result.ok(page);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 通过查询条件查询扫码记录分页信息(经销商)
   *
   * @param dto
   * @return
   */
  @ApiOperation(value = "通过查询条件查询当前参与者的扫码记录分页信息(经销商)")
  @GetMapping(value = "/findDealerByConditions")
  public Result<Page<ScanCodeRecordReportAllVo>> findDealerByConditions(
      @ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
      @ApiParam(name = "dto", value = "扫码记录报表查询dto") ScanCodeRecordReportPaginationDto dto) {
    try {
      Page<ScanCodeRecordReportAllVo> page =
          scanCodeRecordReportAllVoService.findDealerByConditions(pageable, dto);
      return Result.ok(page);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
